/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.client.swing.events.CKeyEvent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.events.CUtilSwingMouseEvent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CColorChooserDialog;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CPopupListener;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.IDialog;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.IDialogParent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingTabbedPane;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventDimension;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventMnemonic;
import de.sillysky.nyssr.remoteskin.model.events.CEventRectangle;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventFileChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventInputDialogAnswer;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventMessageDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventSelectDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowFileChooserDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowInputDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowMessageDialog;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowSelectDialog;
import de.sillysky.nyssr.util.CUtilString;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingComponent
extends CWidget
implements IDialogParent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingComponent.class);
    private CPopupListener mPopUpListener;
    private boolean mOnKeyTyped = false;
    private boolean mOnKeyPressed = false;
    private boolean mOnKeyReleased = false;
    private boolean mOnMouseClick = false;
    private boolean mOnMouseEnter = false;
    private boolean mOnMouseExit = false;
    private boolean mOnMousePress = false;
    private boolean mOnMouseRelease = false;
    private boolean mOnMouseDoubleClick = false;
    private Object mPopupOnLeftClick = null;
    private Object mPopupOnRightClick = null;
    private Set<IDialog> mDialogs = null;

    CSwingComponent(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList ahl = this.getAttributeHandlerList();
        ahl.addHandler("axis", this::applyNothing);
        ahl.addHandler("bounds", this::applyBounds);
        ahl.addHandler("comment", this::applyNothing);
        ahl.addHandler("dimension", this::applyDimension);
        ahl.addHandler("disabled", this::applyDisabled);
        ahl.addHandler("enabled", this::applyEnabled);
        ahl.addHandler("finish", this::applyFinish);
        ahl.addHandler("focusable", this::applyFocusable);
        ahl.addHandler("id", this::applyId);
        ahl.addHandler("invalidate", this::applyInvalidate);
        ahl.addHandler("maximumSize", this::applyMaximumSize);
        ahl.addHandler("minimumSize", this::applyMinimumSize);
        ahl.addHandler("onkeypressed", this::applyOnKeyPressed);
        ahl.addHandler("onkeyreleased", this::applyOnKeyReleased);
        ahl.addHandler("onkeytyped", this::applyOnKeyTyped);
        ahl.addHandler("onMouseClick", this::applyOnMouseClick);
        ahl.addHandler("onMouseDoubleClick", this::applyOnMouseDoubleClick);
        ahl.addHandler("onMouseEnter", this::applyOnMouseEnter);
        ahl.addHandler("onMouseExit", this::applyOnMouseExit);
        ahl.addHandler("onMousePress", this::applyOnMousePress);
        ahl.addHandler("onMouseRelease", this::applyOnMouseRelease);
        ahl.addHandler("parent", this::applyParent);
        ahl.addHandler("popupOnRightClick", this::applyPopupOnClick);
        ahl.addHandler("popupOnLeftClick", this::applyPopupOnLeftClick);
        ahl.addHandler("preferredSize", this::applyPreferredSize);
        ahl.addHandler("repaint", this::applyRepaint);
        ahl.addHandler("revalidate", this::applyRevalidate);
        ahl.addHandler("showColorChooserDialog", this::applyShowColorChooserDialog);
        ahl.addHandler("showFileChooserDialog", this::applyShowFileChooserDialog);
        ahl.addHandler("showStringInputDialog", this::applyShowStringInputDialog);
        ahl.addHandler("showSelectDialog", this::applyShowStringSelectDialog);
        ahl.addHandler("showMsgDialog", this::applyShowMessageDialog);
        ahl.addHandler("splitPanePosition", this::applySplitPanePosition);
        ahl.addHandler("tabColor", this::applyTabColor);
        ahl.addHandler("tabImage", this::applyTabImage);
        ahl.addHandler("tabTitle", this::applyTabTitle);
        ahl.addHandler("templates", this::applyNothing);
        ahl.addHandler("visible", this::applyVisible);
        ahl.addHandler("widgetType", this::applyNothing);
    }

    public void addListeners() {
        this.getComponent().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CSwingComponent.this.mOnMouseClick) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMouseClick", e);
                }
                if (CSwingComponent.this.mOnMouseDoubleClick && e.getClickCount() == 2) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMouseDoubleClick", e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (CSwingComponent.this.mOnMousePress) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMousePress", e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (CSwingComponent.this.mOnMouseRelease) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMouseRelease", e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (CSwingComponent.this.mOnMouseEnter) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMouseEnter", e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (CSwingComponent.this.mOnMouseExit) {
                    CUtilSwingMouseEvent.sendMouseEvent(CSwingComponent.this, "onMouseExit", e);
                }
            }
        });
        this.getComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent aEvent) {
                if (CSwingComponent.this.mOnKeyTyped) {
                    CKeyEvent.sendEvent(CSwingComponent.this, "onkeytyped", aEvent);
                }
            }

            @Override
            public void keyPressed(KeyEvent aEvent) {
                if (CSwingComponent.this.mOnKeyPressed) {
                    CKeyEvent.sendEvent(CSwingComponent.this, "onkeypressed", aEvent);
                }
            }

            @Override
            public void keyReleased(KeyEvent aEvent) {
                if (CSwingComponent.this.mOnKeyReleased) {
                    CKeyEvent.sendEvent(CSwingComponent.this, "onkeyreleased", aEvent);
                }
            }
        });
    }

    private boolean applyParent(@NotNull String aKey, @Nullable Object aValue) {
        return true;
    }

    private boolean applyNothing(@NotNull String aKey, @Nullable Object aValue) {
        return true;
    }

    private boolean applyPopupOnClick(@NotNull String aKey, @Nullable Object aValue) {
        this.mPopupOnRightClick = aValue;
        return true;
    }

    private boolean applyPopupOnLeftClick(@NotNull String aKey, @Nullable Object aValue) {
        this.mPopupOnLeftClick = aValue;
        return true;
    }

    private boolean applyRevalidate(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled) {
                this.getComponent().revalidate();
            }
            return true;
        }
        return false;
    }

    private boolean applyTabImage(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String path = (String)aValue;
            this.getWidgetSet().getContext().requestFile(path, this.getId(), (Object)"tabImage", EFileDeliveryType.AS_IMAGE);
            return true;
        }
        return false;
    }

    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        CWidget parent;
        if ("tabImage".equals(aToken) && (parent = this.getParent()) instanceof CSwingTabbedPane) {
            ((CSwingTabbedPane)parent).setTabImage(this, aImage);
        }
    }

    private boolean applyTabColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null) {
            CWidget parent = this.getParent();
            if (parent instanceof CSwingTabbedPane) {
                ((CSwingTabbedPane)parent).setTabColor(this, event.createColor());
            }
            return true;
        }
        return false;
    }

    private boolean applyVisible(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean visible = (Boolean)aValue;
            this.getComponent().setVisible(visible);
            return true;
        }
        return false;
    }

    private boolean applyPreferredSize(@NotNull String aKey, @Nullable Object aValue) {
        CEventDimension ev = CEventDimension.create((Object)aValue);
        if (ev != null) {
            Dimension dim = ev.getDimension();
            if (dim.width < 0 && dim.height < 0) {
                this.getComponent().setPreferredSize(null);
            } else {
                Dimension preferredSize = this.getComponent().getPreferredSize();
                if (dim.width >= 0) {
                    preferredSize.width = dim.width;
                }
                if (dim.height >= 0) {
                    preferredSize.height = dim.height;
                }
                LOG.debug("{}, set preferred size to w={}, h={}", new Object[]{this.getId(), preferredSize.width, preferredSize.height});
                this.getComponent().setPreferredSize(preferredSize);
            }
            return true;
        }
        return false;
    }

    private boolean applyMaximumSize(@NotNull String aKey, @Nullable Object aValue) {
        CEventDimension ev = CEventDimension.create((Object)aValue);
        if (ev != null) {
            Dimension dim = ev.getDimension();
            if (dim.width < 0 && dim.height < 0) {
                this.getComponent().setMaximumSize(null);
            } else {
                Dimension maximumSize = this.getComponent().getMaximumSize();
                if (dim.width >= 0) {
                    maximumSize.width = dim.width;
                }
                if (dim.height >= 0) {
                    maximumSize.height = dim.height;
                }
                LOG.debug("{}, set maximum size to w={}, h={}", new Object[]{this.getId(), maximumSize.width, maximumSize.height});
                this.getComponent().setMaximumSize(maximumSize);
            }
            return true;
        }
        return false;
    }

    private boolean applyMinimumSize(@NotNull String aKey, @Nullable Object aValue) {
        CEventDimension ev = CEventDimension.create((Object)aValue);
        if (ev != null) {
            Dimension dim = ev.getDimension();
            if (dim.width < 0 && dim.height < 0) {
                this.getComponent().setMinimumSize(null);
            } else {
                Dimension minimumSize = this.getComponent().getMinimumSize();
                if (dim.width >= 0) {
                    minimumSize.width = dim.width;
                }
                if (dim.height >= 0) {
                    minimumSize.height = dim.height;
                }
                LOG.debug("{}, set minimum size to w={}, h={}", new Object[]{this.getId(), minimumSize.width, minimumSize.height});
                this.getComponent().setMinimumSize(minimumSize);
            }
            return true;
        }
        return false;
    }

    private boolean applyShowColorChooserDialog(@NotNull String aKey, @Nullable Object aValue) {
        CColorChooserDialog dlg = new CColorChooserDialog(this);
        this.addDialog(dlg);
        return dlg.show(aKey, aValue);
    }

    private boolean applyShowFileChooserDialog(@NotNull String aKey, @Nullable Object aValue) {
        CEventShowFileChooserDialog event = CEventShowFileChooserDialog.create((Object)aValue);
        if (event != null) {
            CEventFileChooserDialogNotification.EStatus status;
            String approveButtonTooltip;
            CEventMnemonic mnemonic;
            CEventShowFileChooserDialog.EDialogType dialogType = event.getDialogType();
            String path = event.getPath();
            JFileChooser fileChooser = new JFileChooser(path);
            List fileFilterList = event.getFileFilterList();
            for (CEventShowFileChooserDialog.CFileFilter ff : fileFilterList) {
                fileChooser.setFileFilter(new FileNameExtensionFilter(ff.getDescription(), ff.getExtensions()));
            }
            fileChooser.setDialogTitle(event.getTitle());
            fileChooser.setFileHidingEnabled(event.isShowHiddenFiles());
            fileChooser.setMultiSelectionEnabled(event.isMultiSelectionEnabled());
            fileChooser.setAcceptAllFileFilterUsed(event.isAddAllFilesFilter());
            Collection selectedFiles = event.getSelectedFiles();
            if (path != null && !selectedFiles.isEmpty()) {
                ArrayList<File> files = new ArrayList<File>();
                Path currentDirectoryPath = Paths.get(path, new String[0]);
                for (String file : selectedFiles) {
                    Path filePath = currentDirectoryPath.resolve(file);
                    files.add(filePath.toFile());
                }
                fileChooser.setSelectedFiles(files.toArray(new File[0]));
            }
            switch (event.getSelectionMode()) {
                case directories: {
                    fileChooser.setFileSelectionMode(1);
                    break;
                }
                case both: {
                    fileChooser.setFileSelectionMode(2);
                    break;
                }
                default: {
                    fileChooser.setFileSelectionMode(0);
                }
            }
            String approveButtonText = event.getApproveButtonText();
            if (CUtilString.isValid((String)approveButtonText)) {
                fileChooser.setApproveButtonText(approveButtonText);
            }
            if ((mnemonic = event.getApproveButtonMnemonic()) != null) {
                fileChooser.setApproveButtonMnemonic(mnemonic.getSwingConstant());
            }
            if (CUtilString.isValid((String)(approveButtonTooltip = event.getApproveButtonTooltip()))) {
                fileChooser.setApproveButtonToolTipText(approveButtonTooltip);
            }
            int result = dialogType == CEventShowFileChooserDialog.EDialogType.neutral ? fileChooser.showDialog(this.getComponent(), approveButtonText) : (dialogType == CEventShowFileChooserDialog.EDialogType.open ? fileChooser.showOpenDialog(this.getComponent()) : (dialogType == CEventShowFileChooserDialog.EDialogType.save ? fileChooser.showSaveDialog(this.getComponent()) : -1));
            switch (result) {
                case 0: {
                    status = CEventFileChooserDialogNotification.EStatus.approve;
                    break;
                }
                case 1: {
                    status = CEventFileChooserDialogNotification.EStatus.cancel;
                    break;
                }
                default: {
                    status = CEventFileChooserDialogNotification.EStatus.error;
                }
            }
            CEventFileChooserDialogNotification answer = new CEventFileChooserDialogNotification();
            answer.setStatus(status);
            this.addNotification("fileChooserDialogNotification", answer.toJson());
            this.sendNotification();
            return true;
        }
        return false;
    }

    private boolean applyShowStringInputDialog(@NotNull String aKey, @Nullable Object aValue) {
        CEventShowInputDialog event = CEventShowInputDialog.create((Object)aValue);
        if (event != null) {
            Object result;
            ImageIcon icon = null;
            CEventIcon iconEvent = event.getIcon();
            if (iconEvent != null) {
                icon = iconEvent.createIcon(this.getClass());
            }
            CEventInputDialogAnswer answer = new CEventInputDialogAnswer((result = JOptionPane.showInputDialog(this.getComponent(), event.getText(), event.getTitle(), 1, icon, null, event.getDefaultText())) == null ? "" : result.toString());
            Object o = answer.toJson();
            this.addNotification("answerInputDialog", o);
            this.sendNotification();
            return true;
        }
        return false;
    }

    private boolean applyShowStringSelectDialog(@NotNull String aKey, @Nullable Object aValue) {
        CEventShowSelectDialog event = CEventShowSelectDialog.create((Object)aValue);
        if (event != null) {
            Object result;
            ImageIcon icon = null;
            CEventIcon iconEvent = event.getIcon();
            if (iconEvent != null) {
                icon = iconEvent.createIcon(this.getClass());
            }
            CEventSelectDialogNotification answer = new CEventSelectDialogNotification((result = JOptionPane.showInputDialog(this.getComponent(), event.getText(), event.getTitle(), 1, icon, event.getList().toArray(new String[0]), event.getSelection())) == null ? "" : result.toString());
            Object o = answer.toJson();
            this.addNotification("answerSelectDialog", o);
            this.sendNotification();
            return true;
        }
        return false;
    }

    private boolean applyShowMessageDialog(@NotNull String aKey, @Nullable Object aValue) {
        CEventShowMessageDialog event = CEventShowMessageDialog.create((Object)aValue);
        if (event != null) {
            ImageIcon icon = null;
            CEventIcon iconEvent = event.getIcon();
            if (iconEvent != null) {
                icon = iconEvent.createIcon(this.getClass());
            }
            Object[] buttons = event.getButtons();
            int result = JOptionPane.showOptionDialog(this.getComponent(), event.getText(), event.getTitle(), -1, 2, icon, buttons, event.getDefaultButton());
            String button = result == -1 ? "closed" : buttons[result];
            CEventMessageDialogNotification answer = new CEventMessageDialogNotification(button);
            Object o = answer.toJson();
            this.addNotification("answerMsgDialog", o);
            this.sendNotification();
            return true;
        }
        return false;
    }

    private boolean applySplitPanePosition(@NotNull String aKey, @Nullable Object aValue) {
        String position = CUtilString.fromObject((Object)aValue, null);
        if (position != null) {
            this.getProperties().put("splitPanePosition", position);
            return true;
        }
        return false;
    }

    private boolean applyBounds(@NotNull String aKey, @NotNull Object aValue) {
        Component component = this.getComponent();
        CEventRectangle event = CEventRectangle.create((Object)aValue);
        if (event != null) {
            component.setBounds(event.getRectangle());
            LOG.debug("Set {} to {}, {}, {}, {}", new Object[]{aKey, event.getX(), event.getY(), event.getWidth(), event.getHeight()});
            return true;
        }
        return false;
    }

    private boolean applyOnMouseClick(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMouseClick = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnMouseEnter(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMouseEnter = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnMouseExit(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMouseExit = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnMousePress(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMousePress = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnMouseRelease(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMouseRelease = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnMouseDoubleClick(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnMouseDoubleClick = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyDimension(@NotNull String aKey, @Nullable Object aValue) {
        CEventDimension ev = CEventDimension.create((Object)aValue);
        if (ev != null) {
            Dimension dim = ev.getDimension();
            Dimension size = this.getComponent().getSize();
            if (dim.width >= 0) {
                size.width = dim.width;
            }
            if (dim.height >= 0) {
                size.height = dim.height;
            }
            LOG.debug("Set size to {}", new Object[]{size});
            this.getComponent().setSize(size);
            return true;
        }
        return false;
    }

    private boolean applyDisabled(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set Disabled to {}", new Object[]{b});
            this.getComponent().setEnabled(!b);
            return true;
        }
        return false;
    }

    private boolean applyEnabled(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set Enabled to {}", new Object[]{b});
            this.getComponent().setEnabled(b);
            return true;
        }
        return false;
    }

    private boolean applyFinish(@NotNull String aKey, @Nullable Object aValue) {
        return true;
    }

    private boolean applyFocusable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set Focusable to {}", new Object[]{b});
            this.getComponent().setFocusable(b);
            return true;
        }
        return false;
    }

    private boolean applyId(@NotNull String aKey, @Nullable Object aValue) {
        String name;
        if (aValue instanceof String && CUtilString.isValid((String)(name = (String)aValue))) {
            this.getComponent().setName(name);
            return true;
        }
        return false;
    }

    private boolean applyInvalidate(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled) {
                this.getComponent().invalidate();
            }
            return true;
        }
        return false;
    }

    private boolean applyRepaint(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean enabled = (Boolean)aValue;
            if (enabled) {
                this.getComponent().repaint();
            }
            return true;
        }
        return false;
    }

    private boolean applyOnKeyTyped(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnKeyTyped = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnKeyPressed(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnKeyPressed = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnKeyReleased(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnKeyReleased = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private void applyPopupOnClick(@NotNull Object aValue, boolean aLeftToo) {
        try {
            Component component = this.getComponent();
            if (this.mPopUpListener == null) {
                CWidgetSetId widgetSetId = CUtilReference.parseWidgetSetId((Object)aValue);
                CWidgetSetId widgetSetId2 = CWidgetSetId.create((String)widgetSetId.getName(), (String)this.getId().getWidgetSetId().getInstance());
                CWidgetSet widgetSet = this.getWidgetSet();
                IRemoteSkinClientContext context = widgetSet.getContext();
                CWidget widget = context.findOrMountWidgetSet((CWidget)this, widgetSetId2);
                if (widget == null) {
                    LOG.error("Popup {} not found", new Object[]{aValue});
                } else {
                    try {
                        this.mPopUpListener = new CPopupListener(this, widget, aLeftToo);
                        component.addMouseListener(this.mPopUpListener);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e, "Error on loading popup");
                    }
                }
            } else {
                component.removeMouseListener(this.mPopUpListener);
            }
        }
        catch (Exception aE) {
            LOG.error((Throwable)aE, "Error on loading popup");
        }
    }

    private boolean applyTabTitle(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            String s = CUtilString.fromObject((Object)aValue, (String)"-?-");
            this.getProperties().put("tabTitle", s);
            return true;
        }
        return false;
    }

    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Unknown.name();
    }

    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        super.notifyWidget(aNotification, aObjects);
        if (aNotification.equals((Object)ENotification.SHOWN)) {
            if (this.mPopupOnRightClick != null) {
                this.applyPopupOnClick(this.mPopupOnRightClick, false);
            } else if (this.mPopupOnLeftClick != null) {
                this.applyPopupOnClick(this.mPopupOnLeftClick, true);
            }
        }
    }

    private void addDialog(@NotNull IDialog aDialog) {
        if (this.mDialogs == null) {
            this.mDialogs = new HashSet<IDialog>();
        }
        this.mDialogs.add(aDialog);
    }

    @Override
    public void removeDialog(@NotNull IDialog aDialog) {
        if (this.mDialogs != null) {
            this.mDialogs.remove(aDialog);
        }
    }
}

