/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.software.updater.local;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CDownloadRequest {
    private static final ILogger LOG = CLoggerFactory.getLogger(CDownloadRequest.class);
    private static final String REGEX = "^([\\w\\s.#\\\\/-]+)(?:\\((\\w*)\\))?$";
    private static final Pattern PATTERN = Pattern.compile("^([\\w\\s.#\\\\/-]+)(?:\\((\\w*)\\))?$");
    private final String mFilename;
    private final String mHash;
    private final String mPath;
    private final String mRelativePath;
    private File mFile;
    private final String mSearchString;

    @Contract(value="_, _ -> new")
    @NotNull
    static CDownloadRequest parse(@NotNull String aPath, @NotNull String aSearchString) throws CException {
        Matcher matcher = PATTERN.matcher(aSearchString);
        if (matcher.matches()) {
            String filename = matcher.group(1);
            String hash = matcher.group(2);
            return new CDownloadRequest(aSearchString, aPath, filename, hash);
        }
        throw new CException(6).append("Input does not correspond to the expected format: ").append(aSearchString);
    }

    CDownloadRequest(@NotNull String aSearchString, @NotNull String aPath, @NotNull String aFilename, @Nullable String aHash) {
        this.mSearchString = aSearchString;
        this.mPath = aPath;
        this.mFilename = aFilename;
        this.mHash = aHash;
        this.mRelativePath = this.mPath + File.separator + this.mFilename;
    }

    @Nullable
    public String getHash() {
        return this.mHash;
    }

    @NotNull
    public String getFilename() {
        return this.mFilename;
    }

    @NotNull
    public String getPath() {
        return this.mPath;
    }

    @Nullable
    public File getFile() {
        return this.mFile;
    }

    public void setFile(@Nullable File aFile) {
        this.mFile = aFile;
    }

    @NotNull
    public String getSearchString() {
        return this.mSearchString;
    }

    public String toString() {
        return this.mPath + File.separator + this.mSearchString;
    }

    @NotNull
    public String getRelativePath() {
        return this.mRelativePath;
    }
}

