/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.store.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileStoreFile
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"2152ee2c-45fa-4f46-8ad1-e91c3b77fd0c");
    public static final String NAME = "FileStoreFile";
    public static final String DESCRIPTION = "A file record.";
    public static final String SLOT_FILE_LENGTH = "3";
    public static final String SLOT_HASH = "1";
    public static final String SLOT_PATH = "2";
    public static final String SLOT_TIME_OF_CREATION = "4";
    public static final String SLOT_TIME_OF_LAST_MODIFICATION = "5";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static long getFileLength(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE_LENGTH);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static String getHash(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HASH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getPath(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATH);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static Instant getTimeOfCreation(@NotNull CRecord aRecord, Instant aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_OF_CREATION);
        if (slot == null) {
            return aDefault;
        }
        return (Instant)slot.getValue();
    }

    public static Instant getTimeOfLastModification(@NotNull CRecord aRecord, Instant aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_OF_LAST_MODIFICATION);
        if (slot == null) {
            return aDefault;
        }
        return (Instant)slot.getValue();
    }

    public static void setFileLength(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_FILE_LENGTH, slot);
    }

    public static void setHash(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_HASH, slot);
    }

    public static void setPath(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PATH, slot);
    }

    public static void setTimeOfCreation(@NotNull CRecord aRecord, Instant aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INSTANT, (Object)aValue);
        aRecord.addSlot(SLOT_TIME_OF_CREATION, slot);
    }

    public static void setTimeOfLastModification(@NotNull CRecord aRecord, Instant aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INSTANT, (Object)aValue);
        aRecord.addSlot(SLOT_TIME_OF_LAST_MODIFICATION, slot);
    }
}

