/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.entertext;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.web.dialog.entertext.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CAbstractWebDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

class C00002EnterText
extends CAbstractWebDialog {
    private final CStringProperties mParams;
    private static final String ID_00002_MODAL = "id_00002_modal";
    private static final String ID_00002_CLOSE = "id_00002_close";
    private static final String ID_00002_SAVE = "id_00002_save";
    private static final String ID_00002_CANCEL = "id_00002_cancel";
    private static final String ID_00002_EDIT = "id_00002_edit";
    private static final String[] WIDGETS = new String[]{"id_00002_save", "id_00002_cancel", "id_00002_close"};
    private final String mPattern;
    private final String mTitle;
    private final String mMessage;
    private final String mMinLength;
    private final String mMaxLength;
    private final String mPlaceHolder;
    private final String mAriaLabel;

    public C00002EnterText(@NotNull byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId, @NotNull CStringProperties aParams) {
        super(aSessionToken, aClientTargetAddress, aOwnerTargetAddress, aParentWidgetId, CConstants.MICRO_SERVICE_ID);
        this.mParams = aParams;
        this.mMessage = this.mParams.get("message");
        this.mPattern = this.mParams.get("pattern");
        this.mTitle = this.mParams.get("title");
        this.mMinLength = this.mParams.get("minlength");
        this.mMaxLength = this.mParams.get("maxlength");
        this.mPlaceHolder = this.mParams.get("placeholder");
        this.mAriaLabel = this.mParams.get("aria-label");
        this.setResult(this.mParams);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.getWebApi().registerWidgets(WIDGETS);
        this.showDialog();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick1.getId((CRecord)aRecord, null);
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (ID_00002_SAVE.equals(id) && values != null) {
            String value = values.get(ID_00002_EDIT);
            this.mParams.put("result", value);
            this.finish(0);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    public void notifyClick2(@NotNull String aWidgetId) throws CException {
        if (ID_00002_CANCEL.equals(aWidgetId) || ID_00002_CLOSE.equals(aWidgetId)) {
            this.finish(3);
        }
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00002_main.html");
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{message}", (String)(CUtilString.isValid((String)this.mMessage) ? this.mMessage : "Your input:"));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{pattern}", (String)(CUtilString.isValid((String)this.mPattern) ? "pattern=" + this.mPattern : ""));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{title}", (String)(CUtilString.isValid((String)this.mTitle) ? "title=" + this.mTitle : ""));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{minlength}", (String)(CUtilString.isValid((String)this.mMinLength) ? "minlength=" + this.mMinLength : ""));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{maxlength}", (String)(CUtilString.isValid((String)this.mMaxLength) ? "maxlength=" + this.mMaxLength : ""));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{placeholder}", (String)(CUtilString.isValid((String)this.mPlaceHolder) ? "placeholder=" + this.mPlaceHolder : ""));
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{aria-label}", (String)(CUtilString.isValid((String)this.mAriaLabel) ? "aria-label=" + this.mAriaLabel : ""));
        this.getWebApi().setInnerHtml(this.getParentWidgetId(), main);
        this.getWebApi().showModal(ID_00002_MODAL);
        this.getWebApi().addClickListener1(ID_00002_SAVE, new String[]{ID_00002_EDIT});
        this.getWebApi().addClickListener2(new String[]{ID_00002_CANCEL, ID_00002_CLOSE});
        this.getWebApi().setFocus(ID_00002_EDIT);
    }

    protected void clearBeforeDismiss() throws CException {
        this.getWebApi().removeElement(ID_00002_MODAL);
    }
}

