/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.set.creator;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CExceptionLogger;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactory;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactoryRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.widget.parser.IRawWidgetSet;
import de.sillysky.nyssr.widget.parser.IRemoteSkinWidgetSetCreator;
import de.sillysky.nyssr.widget.parser.IWidgetEntry;
import de.sillysky.nyssr.widget.parser.IWidgetEntryList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CRemoteSkinWidgetSetCreator
implements IService,
IRemoteSkinWidgetSetCreator {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinWidgetSetCreator.class);
    private IWidgetFactoryRegistry mWidgetFactoryRegistry;

    CRemoteSkinWidgetSetCreator() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IWidgetFactoryRegistry.class);
    }

    private void addChildren(@NotNull CWidgetSet aWidgetSet, @NotNull IWidgetEntryList aEntryList, @NotNull Map<String, CWidget> aWidgets, @NotNull IWidgetEntry aEntry, @Nullable IWidgetEntry aParent) {
        String key1 = CUtilNormalize.normalize((String)aEntry.getId());
        CWidget currentWidget = aWidgets.get(key1);
        CWidget parent = null;
        if (aParent != null) {
            String key2 = CUtilNormalize.normalize((String)aParent.getId());
            parent = aWidgets.get(key2);
        }
        aWidgetSet.add(currentWidget, parent);
        TreeSet<IWidgetEntry> children = new TreeSet<IWidgetEntry>();
        for (IWidgetEntry e : aEntryList.getEntries()) {
            if (e.getParent() != aEntry) continue;
            children.add(e);
        }
        for (IWidgetEntry e : children) {
            this.addChildren(aWidgetSet, aEntryList, aWidgets, e, aEntry);
        }
    }

    private void createWidgetTree(@NotNull CWidgetSet aWidgetSet, @NotNull IWidgetEntryList aEntryList, @Nullable CWidget aParent) throws Exception {
        HashMap<String, CWidget> widgetMap = new HashMap<String, CWidget>();
        for (IWidgetEntry e : aEntryList.getEntries()) {
            CWidget w;
            String type = e.getWidgetType();
            CUtilCheck.checkEmptyString((Object)type, (String)"WidgetType is missing for %s.", (Object[])new Object[]{e.toString()});
            IWidgetFactory fac = this.mWidgetFactoryRegistry.get(type);
            if (fac == null) {
                CExceptionLogger.logAndThrow((Object)this, (int)5002, (String)"Couldn't find factory for {0}", (Object[])new Object[]{type});
                continue;
            }
            CJsonObject attributes = e.getAttributes();
            if (e.getParent() == null && aParent != null) {
                attributes.put("parent", (Object)aParent.getId());
            }
            if ((w = fac.createWidget(aWidgetSet, e.getId(), attributes)) == null) {
                CExceptionLogger.logAndThrow((Object)this, (int)5003, (String)"Couldn't create widget {0}", (Object[])new Object[]{type});
            }
            widgetMap.put(w.getId().getName(), w);
            CStringProperties properties = e.getProperties();
            for (String key : properties.getKeys()) {
                w.getProperties().put(key, properties.get(key));
            }
            if (!w.getWidgetType().equals(EWidgetTypes.PlaceHolder.name())) continue;
            w.getProperties().put("placeholderid", e.getPlaceHolderId());
        }
        Collection entries = aEntryList.getEntries();
        for (IWidgetEntry e : entries) {
            if (e.getParent() != null) continue;
            this.addChildren(aWidgetSet, aEntryList, widgetMap, e, null);
        }
        for (IWidgetEntry e : entries) {
            CWidget w = aWidgetSet.getWidgets().get(e.getId());
            if (w == null) continue;
            w.applyAttributes(e.getAttributes());
            w.addListeners();
        }
    }

    @NotNull
    public CWidgetSet createWidgetSet(@NotNull IRemoteSkinClientContext aContext, @NotNull IRawWidgetSet aRawWidgetSet, @NotNull String aInstance, @Nullable CWidget aParent, @NotNull CTargetAddress aWidgetSetOwner) throws Exception {
        String instance = aInstance.isEmpty() ? aRawWidgetSet.getInstanceIdFromJson() : aInstance;
        CWidgetSetId id = CWidgetSetId.create((String)aRawWidgetSet.getName(), (String)instance);
        CWidgetSet widgetSet = new CWidgetSet(id, aContext, aWidgetSetOwner);
        this.createWidgetTree(widgetSet, aRawWidgetSet.getWidgetEntries(), aParent);
        LOG.debug("WidgetSet {} successfully parsed.", new Object[]{id});
        return widgetSet;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mWidgetFactoryRegistry = (IWidgetFactoryRegistry)aServiceRegistry.getService(IWidgetFactoryRegistry.class);
        aServiceRegistry.registerService(IRemoteSkinWidgetSetCreator.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }
}

