/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.raw;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import de.sillysky.nyssr.widget.parser.IRawWidgetSet;
import de.sillysky.nyssr.widget.parser.IRawWidgetSetList;
import de.sillysky.nyssr.widget.parser.IRemoteSkinRawJsonParser;
import de.sillysky.nyssr.widget.parser.IRemoteSkinWidgetSetCreator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRawWidgetSetList
implements IService,
IRawWidgetSetList {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRawWidgetSetList.class);
    private final Map<String, IRawWidgetSet> mWidgetSets = new ConcurrentHashMap<String, IRawWidgetSet>();
    private IRemoteSkinRawJsonParser mRemoteSkinRawJsonParser;
    private IRemoteSkinWidgetSetCreator mWidgetSetCreator;

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IRemoteSkinRawJsonParser.class);
        aDependencyList.add(IRemoteSkinWidgetSetCreator.class);
    }

    public void addWidgetSet(@NotNull IRawWidgetSet aWidgetSet) {
        String key = CUtilNormalize.normalize((String)aWidgetSet.getName());
        this.mWidgetSets.put(key, aWidgetSet);
    }

    @Nullable
    public IRawWidgetSet get(@NotNull String aName) {
        String key = CUtilReference.stripPrefix((String)aName);
        key = CUtilNormalize.normalize((String)key);
        return this.mWidgetSets.get(key);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mRemoteSkinRawJsonParser = (IRemoteSkinRawJsonParser)aServiceRegistry.getService(IRemoteSkinRawJsonParser.class);
        this.mWidgetSetCreator = (IRemoteSkinWidgetSetCreator)aServiceRegistry.getService(IRemoteSkinWidgetSetCreator.class);
        aServiceRegistry.registerService(IRawWidgetSetList.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public String addWidgetSet(@NotNull String aJson) throws CException {
        IRawWidgetSet rws = this.mRemoteSkinRawJsonParser.parse(aJson);
        LOG.debug("Add WidgetSet {}", new Object[]{rws.getName()});
        this.addWidgetSet(rws);
        return rws.getName();
    }

    @Nullable
    public CWidgetSet createWidgetSet(@NotNull IRemoteSkinClientContext aContext, @NotNull CWidgetSetId aWidgetSetId, @Nullable CWidget aParent, @NotNull CTargetAddress aOwner) throws Exception {
        IRawWidgetSet rawWidgetSet = this.get(aWidgetSetId.getName());
        if (rawWidgetSet != null) {
            return this.mWidgetSetCreator.createWidgetSet(aContext, rawWidgetSet, aWidgetSetId.getInstance(), aParent, aOwner);
        }
        return null;
    }
}

