/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.server;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.server.CTcpServer;
import de.sillysky.nyssr.impl.tcp.server.IDependencies;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.tcp.ITcpServer;
import de.sillysky.nyssr.tcp.ITcpServerFactory;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

final class CTcpServerFactory
implements ITcpServerFactory,
IService {
    private final IDependencies mDependencies;

    CTcpServerFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(ITcpServerFactory.class, (Object)this);
    }

    @Override
    public ITcpServer createServer(CStringProperties aProperties) throws CException {
        CTcpServer server = new CTcpServer();
        try {
            server.activateInstance(this.mDependencies, aProperties);
        }
        catch (Exception e) {
            throw new CException(2).append((Object)e);
        }
        return server;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void deleteTcpServer(ITcpServer aTcpServer) {
        CTcpServer server = (CTcpServer)aTcpServer;
        server.deactivateInstance();
    }
}

