/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.user.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.app.user.manager.ILocalAppContext;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.panel.CConstants;
import de.sillysky.nyssr.message.panel.records.CRecordAddMessages;
import de.sillysky.nyssr.message.panel.records.CRecordOpenDialogMessagePanel;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.target.ITarget;
import org.jetbrains.annotations.NotNull;

class CMessagePanelHolder {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"app.user.manager");
    private ILocalAppContext mLocalAppContext;
    private ITarget mTarget;
    private CTargetAddress mAddress;

    CMessagePanelHolder(@NotNull ILocalAppContext aLocalAppContext, @NotNull ITarget aTarget) {
        this.mLocalAppContext = aLocalAppContext;
        this.mTarget = aTarget;
    }

    void setAddress(CTargetAddress aAddress) {
        this.mAddress = aAddress;
    }

    private void close() throws CException {
        if (this.mAddress != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mAddress);
            CRecord record = CRecordCloseDialog.create();
            this.mTarget.sendNotification(env, record);
            this.mAddress = null;
        }
    }

    void deactivate() throws CException {
        this.close();
        this.mTarget = null;
        this.mLocalAppContext = null;
    }

    void sendAddMessageToHistory(@NotNull String aText) {
        if (this.mAddress != null) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mAddress);
                CRecord rec = CRecordAddMessages.create();
                CRecordAddMessages.setMessages((CRecord)rec, (String[])new String[]{aText});
                this.mTarget.sendNotification(env, rec);
            }
            catch (CException aE) {
                LOG.error("Couldn't send Message {}", new Object[]{aText});
            }
        }
    }

    void show(@NotNull CWidgetId aParentWidgetId) throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstants.MESSAGE_HISTORY_PANEL);
        env.setSessionToken(this.mLocalAppContext.getApplicationContext().getSessionToken());
        IRemoteSkinClientContext clientContext = this.mLocalAppContext.getClientContext();
        CRecord record = CRecordOpenDialogMessagePanel.create();
        CRecordOpenDialogMessagePanel.setPanelType((CRecord)record, (int)400);
        CRecordOpenDialogMessagePanel.setCenterDlgAbove((CRecord)record, (CWidgetId)aParentWidgetId);
        CUtilDialogHelper.enrichOpenDialogRecord((CRecord)record, (IRemoteSkinClientContext)clientContext, (CWidgetId)aParentWidgetId);
        this.mTarget.sendRequest(env, record);
    }
}

