/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.registry.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordFileRegistryGetFilePaths
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"fcbfda81-b40d-4bae-ad11-5a5d0a2da8f7");
    public static final String NAME = "FileRegistryGetFilePaths";
    public static final String DESCRIPTION = "Get information about all (max 1000) file paths registered in the registry for a given directory.";
    public static final String SLOT_DIRECTORY = "dir";
    public static final String SLOT_PATHS = "rec";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getDirectory(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DIRECTORY);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String[] getPaths(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATHS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setDirectory(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_DIRECTORY, slot);
    }

    public static void setPaths(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_PATHS, slot);
    }
}

