/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.impl.dialog.user.CUtilUserDialog;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CRight;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class C708Handler {
    private final CMainTarget mMainTarget;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs708;
    private final CWidgetId m708Dialog;
    private final CWidgetId m708ListRights;
    private final CWidgetId m708ButtonOkay;
    private final ArrayList<String> mSelectedRights = new ArrayList();
    private boolean m708ButtonOkayIsEnabled;
    private boolean m708open;
    private CWidgetId mParentWidget;
    private String mRoleId;
    private Collection<CRight> mAllRights;
    private Collection<CRight> mRightsOfRole;

    C708Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs708 = CWidgetSetId.create((String)"@708_ChooseRights", (String)aInstance);
        this.m708Dialog = CWidgetId.create((String)"#708_Dialog", (CWidgetSetId)this.mWs708);
        this.mApi.addListener(this.m708Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m708ListRights = CWidgetId.create((String)"#708_ListRights", (CWidgetSetId)this.mWs708);
        this.mApi.addListener(this.m708ListRights, (IListener)((IListSelectionListener)this::onListRightSelection));
        this.m708ButtonOkay = CWidgetId.create((String)"#708_ButtonOkay", (CWidgetSetId)this.mWs708);
        this.mApi.addListener(this.m708ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        CWidgetId buttonCancel = CWidgetId.create((String)"#708_ButtonCancel", (CWidgetSetId)this.mWs708);
        this.mApi.addListener(buttonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget, @NotNull String aRoleId) {
        if (!this.m708open) {
            this.m708open = true;
            this.mParentWidget = aParentWidget;
            this.mRoleId = aRoleId;
            this.m708ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs708, this.mParentWidget, "#708_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    void setAllRights(@NotNull Collection<CRight> aRights) {
        this.mAllRights = new ArrayList<CRight>(aRights);
        this.fillRights();
    }

    void setRightsOfRole(@NotNull String aRoleId, @NotNull Collection<CRight> aRights) {
        if (aRoleId.equals(this.mRoleId)) {
            this.mRightsOfRole = new ArrayList<CRight>(aRights);
            this.fillRights();
        }
    }

    private void fillRights() {
        if (this.m708open && this.mRightsOfRole != null && this.mAllRights != null) {
            ArrayList<CRight> list = new ArrayList<CRight>(this.mAllRights);
            list.removeIf(right -> this.mRightsOfRole.contains(right));
            CUtilUserDialog.fillList(this.mApi, this.m708ListRights, list);
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs708.equals((Object)aWidgetSetId)) {
            this.mApi.pack(this.m708Dialog);
            this.mApi.centerWidget(this.m708Dialog, this.mParentWidget);
            this.mApi.setVisible(this.m708Dialog, true);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m708open) {
            this.m708open = false;
            this.mApi.unmount(this.m708Dialog);
            this.sendUpdate();
        }
    }

    private void sendUpdate() {
        this.mServerContext.sendUpdate();
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.notify708ButtonOkayPressed(this.mRoleId, this.mSelectedRights);
        this.unmount();
        this.mMainTarget.update706();
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onListRightSelection(@NotNull CEventListSelectionNotification aEvent) {
        this.mSelectedRights.clear();
        List selectedIds = aEvent.getSelectedIds();
        this.mSelectedRights.addAll(selectedIds);
        this.checkOkayButton();
    }

    private void checkOkayButton() {
        if (this.mSelectedRights.isEmpty() == this.m708ButtonOkayIsEnabled) {
            this.m708ButtonOkayIsEnabled = !this.m708ButtonOkayIsEnabled;
            this.mApi.setEnabled(this.m708ButtonOkay, this.m708ButtonOkayIsEnabled);
            this.sendUpdate();
        }
    }
}

