/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.service;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceInstanceEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.util.CUtilRandom;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMicroServiceEntry {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"microservice.registry");
    @NotNull
    private final CMicroServiceDescription mMicroService;
    private final Map<IId, CMicroServiceInstanceEntry> mInstances = new HashMap<IId, CMicroServiceInstanceEntry>();

    public CMicroServiceEntry(@NotNull CMicroServiceDescription aMicroService) {
        this.mMicroService = aMicroService;
    }

    public boolean addInstance(@NotNull IId aInstanceId, @NotNull CTargetAddress aInstanceAddress, @Nullable ZonedDateTime aTimeAdded) {
        CMicroServiceInstanceEntry inst = this.mInstances.get(aInstanceId);
        if (inst != null) {
            inst.refresh(aInstanceAddress);
            LOG.debug("MicroServices: Instance {} updated with {}. Count is now: {}", new Object[]{aInstanceId, aInstanceAddress, this.mInstances.size()});
            return false;
        }
        inst = new CMicroServiceInstanceEntry(this.mMicroService.getId(), aInstanceId, aInstanceAddress, aTimeAdded);
        this.mInstances.put(aInstanceId, inst);
        LOG.debug("MicroServices: Instance {} with address {} added. Count is now: {}", new Object[]{aInstanceId, aInstanceAddress, this.mInstances.size()});
        return true;
    }

    public boolean equals(Object aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null || this.getClass() != aOther.getClass()) {
            return false;
        }
        CMicroServiceEntry that = (CMicroServiceEntry)aOther;
        return this.mMicroService.equals((Object)that.mMicroService);
    }

    int getInstanceCount() {
        return this.mInstances.size();
    }

    public List<CMicroServiceInstanceEntry> getInstances() {
        return new ArrayList<CMicroServiceInstanceEntry>(this.mInstances.values());
    }

    @NotNull
    public CMicroServiceDescription getMicroService() {
        return this.mMicroService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CTargetAddress getRandomInstance() {
        Map<IId, CMicroServiceInstanceEntry> map = this.mInstances;
        synchronized (map) {
            int size = this.mInstances.size();
            if (size > 0) {
                int index = 0;
                if (size > 1) {
                    Random random = CUtilRandom.getRandom();
                    index = random.nextInt(size);
                }
                int i = 0;
                for (CMicroServiceInstanceEntry a : this.mInstances.values()) {
                    if (i == index) {
                        return a.getTargetAddress();
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    public int hashCode() {
        return this.mMicroService.hashCode();
    }

    private void logRemoved(@NotNull CMicroServiceInstanceEntry aInstance) {
        LOG.debug("MicroServices: Instance {} removed. Count is now: {}", new Object[]{aInstance, this.mInstances.size()});
    }

    void notifyNodeDeleted(CNodeAddress aNode) {
        Iterator<CMicroServiceInstanceEntry> it = this.mInstances.values().iterator();
        while (it.hasNext()) {
            CMicroServiceInstanceEntry a = it.next();
            if (!a.getTargetAddress().getNodeAddress().equals((Object)aNode)) continue;
            this.logRemoved(a);
            it.remove();
        }
    }

    public void removeInstanceByAddress(@NotNull CTargetAddress aAddress) {
        Iterator<CMicroServiceInstanceEntry> it = this.mInstances.values().iterator();
        while (it.hasNext()) {
            CMicroServiceInstanceEntry entry = it.next();
            if (!entry.getTargetAddress().equals((Object)aAddress)) continue;
            this.logRemoved(entry);
            it.remove();
        }
    }

    @Nullable
    public CMicroServiceInstanceEntry getInstanceById(@NotNull IId aId) {
        return this.mInstances.get(aId);
    }

    public boolean removeInstance(@NotNull CMicroServiceInstanceEntry aInstanceEntry) {
        CMicroServiceInstanceEntry removed = this.mInstances.remove(aInstanceEntry.getInstanceId());
        return removed != null;
    }
}

