/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.link.cost.collector;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.link.cost.collector.CCostList;
import de.sillysky.nyssr.impl.network.link.cost.collector.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.network.link.cost.collector.CConstantsLinkCostCollector;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordAddLinkCosts;
import de.sillysky.nyssr.network.link.cost.collector.records.CRecordBroadcastLinkCosts;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CLinkCostCollector
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"network.costs");
    private static final IId TIMER_ID = CIdFactory.fromObject((Object)"LinkCostTimer");
    private final IDependencies mDependencies;
    private final CCostList mCostList = new CCostList();
    private long mTimeout = 10L;
    private int mTimeoutRemoveOldEntries = 3600000;
    private CTimer mTimer;
    private Map<UUID, Integer> mFixCosts = new HashMap<UUID, Integer>();

    CLinkCostCollector(IDependencies aDependencies) {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAddLinkCosts.ID, this::asyncAddLinkCosts);
        this.addMessageHandler(TIMER_ID, this::asyncTimerBroadcast);
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.loadCostsFromPreferences();
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "TRANSPORT");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        ArrayList<CDescriptionOfRecord> nanoList = new ArrayList<CDescriptionOfRecord>();
        nanoList.add(new CDescriptionOfRecord(CRecordAddLinkCosts.ID, "Add costs for a link between two nodes"));
        IId microServiceInstanceId = CIdFactory.random();
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsLinkCostCollector.MICRO_SERVICE_ID, "Collect costs for links between nodes", nanoList, microServiceInstanceId, this.getAddress());
        INamespace system = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (system != null);
        system.getNanoServiceRegistry().addNanoService(CRecordBroadcastLinkCosts.ID, "BroadCastLinkCosts");
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER_ID, this.getAddress(), this.mTimeout * 1000L, false, null);
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddLinkCosts(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID[] connectionIds = CRecordAddLinkCosts.getConnectionIds((CRecord)aRecord, null);
        int[] costs = CRecordAddLinkCosts.getCosts((CRecord)aRecord, null);
        int length = connectionIds.length;
        LOG.debug("Got {} cost records from {}", new Object[]{length, aEnvelope.getSender().getNodeId()});
        for (int i = 0; i < length; ++i) {
            Integer cost = this.mFixCosts.get(connectionIds[i]);
            if (cost == null) {
                this.mCostList.addCosts(connectionIds[i], costs[i], false);
                continue;
            }
            this.mCostList.addCosts(connectionIds[i], cost, true);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncTimerBroadcast(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTimer.notifyTriggerOccurred();
        this.broadCast();
        this.mTimer.startIfElseReset();
        this.mCostList.removeOldEntries(this.mTimeoutRemoveOldEntries);
        aEnvelope.setResultSuccess();
        return true;
    }

    private void loadCostsFromPreferences() {
        try {
            Preferences preferences = this.mDependencies.getKernelConfiguration().getPreferences("network");
            this.mTimeout = preferences.getLong("network.timout.broadcast.costs.in.seconds", 60L);
            this.mTimeoutRemoveOldEntries = preferences.getInt("network.timout.remove.old.costs.in.seconds", 3600);
            preferences = preferences.node("costs");
            for (String key : preferences.keys()) {
                UUID connectionId = UUID.fromString(key);
                if (!CUtilUuid.isValid((UUID)connectionId)) continue;
                int costs = preferences.getInt(key, 1);
                this.mFixCosts.put(connectionId, costs);
            }
        }
        catch (BackingStoreException aE) {
            LOG.error((Throwable)aE, "error loading link costs");
        }
    }

    void broadCast() throws CException {
        int size = this.mCostList.size();
        if (size > 0) {
            this.dump();
            CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
            CRecord record = this.mCostList.createBroadcastRecord();
            LOG.debug("Send Cost Broadcast with {} entries", new Object[]{size});
            this.broadCast(env, record);
        }
    }

    void broadCast(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        aEnvelope.setSender(this.getAddress());
        CMessage msgToSend = new CMessage(aEnvelope, aRecord);
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord rec = CRecordBroadcastSendMsg.create();
        CRecordBroadcastSendMsg.setLocally((CRecord)rec, (boolean)true);
        CRecordBroadcastSendMsg.setMessage((CRecord)rec, (CMessage)msgToSend);
        this.send(env, rec);
    }

    private void dump() {
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder(3000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("Link Costs:\n");
            this.mCostList.dump(sb);
            sb.append(CUtilString.LINE);
            LOG.trace(sb.toString());
        }
    }
}

