/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.target.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordStartTarget
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("42e31e06-40f6-4c84-870f-1e54bec696bd");
    public static final String NAME = "StartTarget";
    public static final String DESCRIPTION = "The first message a target will get (asynchronously).";
    public static final String SLOT_MESSAGE_SENDER = "4";
    public static final String SLOT_QID = "2";
    public static final String SLOT_TARGET_ADDRESS = "1";
    public static final String SLOT_TARGET_REGISTRY = "3";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static Object getMessageSender(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE_SENDER);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static IId getQid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_QID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress getTargetAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGET_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static Object getTargetRegistry(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TARGET_REGISTRY);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static void setMessageSender(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.OBJECT, aValue);
        aRecord.addSlot(SLOT_MESSAGE_SENDER, slot);
    }

    public static void setQid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_QID, slot);
    }

    public static void setTargetAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_TARGET_ADDRESS, slot);
    }

    public static void setTargetRegistry(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.OBJECT, aValue);
        aRecord.addSlot(SLOT_TARGET_REGISTRY, slot);
    }
}

