/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log.catcher.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordUpdateLogVars
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("c14853d5-db30-407d-9ccb-f2079354f45f");
    public static final String NAME = "UpdateLogVars";
    public static final String DESCRIPTION = "Update for log variables, like encoder pattern, known logger names etc.";
    public static final String SLOT_KNOWN_LEVELS = "2";
    public static final String SLOT_LOGGER_LEVEL = "4";
    public static final String SLOT_LOGGER_NAMES = "3";
    public static final String SLOT_PATTERN = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getKnownLevels(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_KNOWN_LEVELS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getLoggerLevel(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOGGER_LEVEL);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getLoggerNames(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOGGER_NAMES);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String getPattern(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PATTERN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setKnownLevels(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_KNOWN_LEVELS, slot);
    }

    public static void setLoggerLevel(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_LOGGER_LEVEL, slot);
    }

    public static void setLoggerNames(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_LOGGER_NAMES, slot);
    }

    public static void setPattern(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_PATTERN, slot);
    }
}

