/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace;

import de.sillysky.nyssr.impl.namespace.CNamespaceFactory;
import de.sillysky.nyssr.impl.namespace.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.message.hook.IMessageHookRegistry;
import de.sillysky.nyssr.message.queue.IMessageQueueRegistryFactory;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistryFactory;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.target.registry.ITargetRegistryFactory;
import org.jetbrains.annotations.NotNull;

public class CPackageImplNamespace
implements IServiceStarter,
IDependencies {
    private IService mService;
    private IKernelConfiguration mKernelConfiguration;
    private INamespaceRegistry mNamespaceRegistry;
    private IMessageHookRegistry mMessageHookRegistry;
    private IMessageQueueRegistryFactory mMessageQueueRegistryFactory;
    private INanoServiceRegistryFactory mNanoServiceRegistryFactory;
    private ITargetRegistryFactory mTargetRegistryFactory;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(IMessageHookRegistry.class);
        aDependencyList.add(IMessageQueueRegistryFactory.class);
        aDependencyList.add(INanoServiceRegistryFactory.class);
        aDependencyList.add(ITargetRegistryFactory.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mKernelConfiguration = aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mNamespaceRegistry = aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
            this.mMessageHookRegistry = aServiceRegistry.getServiceOrThrow(IMessageHookRegistry.class);
            this.mMessageQueueRegistryFactory = aServiceRegistry.getServiceOrThrow(IMessageQueueRegistryFactory.class);
            this.mNanoServiceRegistryFactory = aServiceRegistry.getServiceOrThrow(INanoServiceRegistryFactory.class);
            this.mTargetRegistryFactory = aServiceRegistry.getServiceOrThrow(ITargetRegistryFactory.class);
            this.mService = new CNamespaceFactory(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }

    @Override
    public INamespaceRegistry getNamespaceRegistry() {
        return this.mNamespaceRegistry;
    }

    @Override
    public IMessageHookRegistry getMessageHookRegistry() {
        return this.mMessageHookRegistry;
    }

    @Override
    public IMessageQueueRegistryFactory getMessageQueueRegistryFactory() {
        return this.mMessageQueueRegistryFactory;
    }

    @Override
    public INanoServiceRegistryFactory getNanoServiceRegistryFactory() {
        return this.mNanoServiceRegistryFactory;
    }

    @Override
    public ITargetRegistryFactory getTargetRegistryFactory() {
        return this.mTargetRegistryFactory;
    }
}

