/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.message.logger;

import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.message.logger.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.logger.IMessageLogger;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CMessageLogger
implements IMessageLogger {
    private final IDependencies mDependencies;
    private final ILogger mLogger;
    private int mNumber = 0;

    CMessageLogger(@NotNull IDependencies aDependencies, @NotNull Object aOwner) {
        this.mDependencies = aDependencies;
        this.mLogger = aOwner instanceof ILogger ? (ILogger)aOwner : CLoggerFactory.getLogger(aOwner.getClass());
    }

    @Override
    @NotNull
    public ILogger getLogger() {
        return this.mLogger;
    }

    private int getNextNo() {
        ++this.mNumber;
        return this.mNumber;
    }

    @Override
    @NotNull
    public String getRecordIdName(@NotNull CRecord aRecord) {
        IId id = aRecord.getId();
        return this.mDependencies.getNameDb().getRecordIdDatabase().getName(id);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.mLogger.isTraceEnabled();
    }

    @Override
    @NotNull
    public String logAfter(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord, boolean aHandled) {
        StringBuilder sb = new StringBuilder(120);
        sb.append("<<< ");
        String name = this.getRecordIdName(aRecord);
        sb.append(name);
        sb.append(' ');
        sb.append(this.mNumber);
        if (!aEnvelope.isAnswer()) {
            String resultText;
            int resultCode;
            if (!aHandled) {
                sb.append(" not handled");
            }
            if ((resultCode = aEnvelope.getResultCode()) != 0) {
                sb.append(", ResultCode=").append(resultCode);
            }
            if (CUtilString.isValid(resultText = aEnvelope.getResultText())) {
                sb.append(", ResultText=").append(resultText);
            }
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String logBefore(@Nullable Object aOwner, @NotNull String aHandlerName, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        StringBuilder sb = new StringBuilder(400);
        sb.append(">>> ");
        sb.append(this.logMessageHeader(aEnvelope, aRecord));
        sb.append(" handled in ");
        if (aOwner != null) {
            sb.append(aOwner);
        }
        sb.append(" Handler=");
        sb.append(aHandlerName);
        sb.append(" No=");
        sb.append(this.getNextNo());
        return sb.toString();
    }

    @Override
    @NotNull
    public String logMessage(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        StringBuilder sb = new StringBuilder(500);
        sb.append(CUtilString.CRLF);
        sb.append(CUtilString.LINE_CRLF);
        sb.append(aEnvelope);
        sb.append(aRecord);
        sb.append(CUtilString.CRLF);
        sb.append(CUtilString.LINE_CRLF);
        return sb.toString();
    }

    @Override
    @NotNull
    public String logMessageHeader(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        StringBuilder sb = new StringBuilder(50);
        if (aEnvelope.isAnswer()) {
            sb.append("Answer ");
        }
        IId id = aRecord.getId();
        sb.append(this.mDependencies.getNameDb().getRecordIdDatabase().getName(id));
        return sb.toString();
    }

    @Override
    @NotNull
    public String logNotHandled(@Nullable Object aOwner, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        StringBuilder sb = new StringBuilder(400);
        sb.append(">.< ");
        sb.append(this.logMessageHeader(aEnvelope, aRecord));
        sb.append(" NOT handled in ");
        if (aOwner != null) {
            sb.append(aOwner);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String logRecord(@NotNull CRecord aRecord) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("Record:");
        IId id = aRecord.getId();
        sb.append(" ID=");
        sb.append(id);
        String idName = this.mDependencies.getNameDb().getRecordIdDatabase().getNameOrNull(id);
        if (idName != null) {
            sb.append("(");
            sb.append(idName);
            sb.append(")");
        }
        Map<String, ISlot> slots = aRecord.getSlots();
        int size = slots.size();
        sb.append(String.format(" SlotCount:   %d", size));
        if (size > 0) {
            sb.append(": ");
            for (Map.Entry<String, ISlot> entry : slots.entrySet()) {
                String key = entry.getKey();
                sb.append(key);
                sb.append('=');
                ISlot slot = entry.getValue();
                if (slot == null) {
                    sb.append("null");
                } else {
                    sb.append(slot.getType().getName());
                    sb.append('(');
                    sb.append(slot);
                    sb.append(')');
                }
                sb.append(' ');
            }
        }
        return sb.toString();
    }
}

