/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.file.manager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.configuration.files.records.CRecordCreateConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordDeleteConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordGetConfigFileContent;
import de.sillysky.nyssr.configuration.files.records.CRecordGetConfigFileList;
import de.sillysky.nyssr.configuration.files.records.CRecordSetConfigFileContent;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.kernel.config.file.manager.CWorkingTarget;
import de.sillysky.nyssr.impl.kernel.config.file.manager.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IConfigFileManager;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CConfigFileManager
extends CTarget
implements IService,
IConfigFileManager {
    private final IDependencies mDependencies;

    CConfigFileManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordGetConfigFileList.ID, this::asyncGetConfigFileList);
        this.addMessageHandler(CRecordGetConfigFileContent.ID, this::asyncGetConfigFileContent);
        this.addMessageHandler(CRecordSetConfigFileContent.ID, this::asyncSetConfigFileContent);
        this.addMessageHandler(CRecordDeleteConfigFile.ID, this::asyncDeleteConfigFile);
        this.addMessageHandler(CRecordCreateConfigFile.ID, this::asyncCreateConfigFile);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        INamespace ns = this.mDependencies.getSystemNamespace();
        ns.getTargetRegistry().registerTarget(this);
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        INanoServiceRegistry nsr = this.mDependencies.getSystemNamespace().getNanoServiceRegistry();
        nsr.addNanoServiceAndObserver(CRecordCreateConfigFile.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordDeleteConfigFile.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordGetConfigFileList.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordGetConfigFileContent.class, address, false);
        nsr.addNanoServiceAndObserver(CRecordSetConfigFileContent.class, address, false);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetConfigFileList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Path configurationPath = this.mDependencies.getKernelConfiguration().getConfigurationPath();
        List<Path> files = CUtilPath.getListOfFiles(configurationPath, ".cfg");
        String[] stringArray = (String[])files.stream().map(Path::toString).toArray(String[]::new);
        CRecordGetConfigFileList.setList(aRecord, stringArray);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetConfigFileContent(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        String path = CRecordGetConfigFileContent.getPath(aRecord, null);
        CUtilCheck.checkEmptyStringEx(path, "Path missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSetConfigFileContent(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        String path = CRecordSetConfigFileContent.getPath(aRecord, null);
        CUtilCheck.checkEmptyStringEx(path, "Path missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncCreateConfigFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        String fileName = CRecordCreateConfigFile.getFilename(aRecord, null);
        CUtilCheck.checkEmptyStringEx(fileName, "Filename missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncDeleteConfigFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNull(sessionToken, "SessionToken missing", new Object[0]);
        String path = CRecordDeleteConfigFile.getPath(aRecord, null);
        CUtilCheck.checkEmptyStringEx(path, "Path missing", new Object[0]);
        this.getTargetRegistry().registerTarget(new CWorkingTarget(this.mDependencies, sessionToken, aEnvelope, aRecord));
        aEnvelope.setResultSuccess();
        return true;
    }
}

