/*
 * Copyright (c) since 2023 by sillysky.net.
 * All rights reserved.
 * This file is subject to the terms and conditions defined in file 'LICENSE.txt',
 * which is part of this source code package.
 */

// Beispiel-Daten
[id_00401_nodes]


// SVG-Element auswählen
var svg = d3.select("#id_svg");
console.log(svg);

// Simulations-Setup
var simulation = d3.forceSimulation(nodes)
    .force("link", d3.forceLink(links).id(d => d.id).distance(100))
    .force("charge", d3.forceManyBody().strength(-300))
    .force("center", d3.forceCenter(300, 200));

// Links erstellen
var link = svg.append("g")
    .attr("class", "links")
    .attr("stroke-width", "7")
    .selectAll("line")
    .data(links)
    .enter()
    .append("line")
    .attr("class", "link")
    .on("click", (event, d) => {
        console.log("Link clicked:", d);
    });

// Knoten erstellen
var node = svg.append("g")
    .attr("class", "nodes")
    .selectAll("g")
    .data(nodes)
    .enter()
    .append("g")
    .attr("class", "node")
    .call(d3.drag()
        .on("start", dragstarted)
        .on("drag", dragged)
        .on("end", dragended))
    .on("click", (event, d) => {
        console.log("Node clicked:", d);
    });

// Kreise hinzufügen
node.append("circle")
    .attr("r", 30);

// Text hinzufügen
node.append("text")
    .text(d => d.id);

// Tooltip hinzufügen (optional)
node.append("title")
    .text(d => d.name);

// Simulations-Update
simulation.on("tick", () => {
    link
        .attr("x1", d => d.source.x)
        .attr("y1", d => d.source.y)
        .attr("x2", d => d.target.x)
        .attr("y2", d => d.target.y);

    node
        .attr("transform", d => `translate(${d.x},${d.y})`);
});

// Drag-Event-Handler
function dragstarted(event, d) {
    if (!event.active) simulation.alphaTarget(0.3).restart();
    d.fx = d.x;
    d.fy = d.y;
}

function dragged(event, d) {
    d.fx = event.x;
    d.fy = event.y;
}

function dragended(event, d) {
    if (!event.active) simulation.alphaTarget(0);
    d.fx = null;
    d.fy = null;
}
