/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyAppInstanceStopped
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"1ad3c911-741c-4d4f-b726-f9fa041ff138");
    public static final String NAME = "NotifyAppInstanceStopped";
    public static final String DESCRIPTION = "Whenever an application instance has been stopped finally, this notification service will be triggered. Direction: App Instance Registry --> Public.";
    public static final String SLOT_INSTANCE = "1";
    public static final String SLOT_RESULT_CODE = "2";
    public static final String SLOT_RESULT_TEXT = "3";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord getInstance(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static int getResultCode(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RESULT_CODE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static String getResultText(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RESULT_TEXT);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setInstance(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE, slot);
    }

    public static void setResultCode(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_RESULT_CODE, slot);
    }

    public static void setResultText(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_RESULT_TEXT, slot);
    }
}

