/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordDataApplicationInstance
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"809ea605-f650-4c75-97b1-22a8c4e43ab7");
    public static final String NAME = "DataApplicationInstance";
    public static final String DESCRIPTION = "An application instance.";
    public static final String SLOT_APPLICATION_DESCRIPTION1 = "1";
    public static final String SLOT_APPLICATION_DESCRIPTION2 = "2";
    public static final String SLOT_APPLICATION_ICON = "3";
    public static final String SLOT_APPLICATION_ID = "4";
    public static final String SLOT_APPLICATION_NAME = "5";
    public static final String SLOT_INSTANCE_ACTIVITY_COUNTER = "6";
    public static final String SLOT_INSTANCE_ADDRESS = "7";
    public static final String SLOT_INSTANCE_ID = "8";
    public static final String SLOT_INSTANCE_NID = "9";
    public static final String SLOT_INSTANCE_NODE = "10";
    public static final String SLOT_INSTANCE_STATUS = "11";
    public static final String SLOT_INSTANCE_TIME_STARTED = "12";
    public static final String SLOT_PRESET_NAME = "13";
    public static final String SLOT_PRESET_PROPERTIES = "14";
    public static final String SLOT_REMOTE_SKIN_CLIENT_NODE = "15";
    public static final String SLOT_SESSION_TOKEN = "16";
    public static final String SLOT_USER_ID = "17";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getApplicationDescription1(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_DESCRIPTION1);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getApplicationDescription2(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_DESCRIPTION2);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getApplicationIcon(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_ICON);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getApplicationId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static String getApplicationName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATION_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static long getInstanceActivityCounter(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ACTIVITY_COUNTER);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static CTargetAddress getInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static UUID getInstanceId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static IId getInstanceNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CNodeAddress getInstanceNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static String getInstanceStatus(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_STATUS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static LocalDateTime getInstanceTimeStarted(@NotNull CRecord aRecord, LocalDateTime aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_TIME_STARTED);
        if (slot == null) {
            return aDefault;
        }
        return (LocalDateTime)slot.getValue();
    }

    public static String getPresetName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRESET_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CStringProperties getPresetProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRESET_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static CNodeAddress getRemoteSkinClientNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_SKIN_CLIENT_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getUserId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_USER_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setApplicationDescription1(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_DESCRIPTION1, slot);
    }

    public static void setApplicationDescription2(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_DESCRIPTION2, slot);
    }

    public static void setApplicationIcon(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_ICON, slot);
    }

    public static void setApplicationId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_ID, slot);
    }

    public static void setApplicationName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATION_NAME, slot);
    }

    public static void setInstanceActivityCounter(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.LONG, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ACTIVITY_COUNTER, slot);
    }

    public static void setInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ADDRESS, slot);
    }

    public static void setInstanceId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ID, slot);
    }

    public static void setInstanceNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_NID, slot);
    }

    public static void setInstanceNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_NODE, slot);
    }

    public static void setInstanceStatus(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_STATUS, slot);
    }

    public static void setInstanceTimeStarted(@NotNull CRecord aRecord, LocalDateTime aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UTC_TIMESTAMP, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_TIME_STARTED, slot);
    }

    public static void setPresetName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PRESET_NAME, slot);
    }

    public static void setPresetProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING_PROPERTIES, (Object)aValue);
        aRecord.addSlot(SLOT_PRESET_PROPERTIES, slot);
    }

    public static void setRemoteSkinClientNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_SKIN_CLIENT_NODE, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }

    public static void setUserId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_USER_ID, slot);
    }
}

