/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordAppRunApplication
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"63718686-bc2d-458e-93df-c38c3bd06f1d");
    public static final String NAME = "AppRunApplication";
    public static final String DESCRIPTION = "Create and start an Application Instance. This service is provided by the application registry. Direction: Public --> App Instance Registry";
    public static final String SLOT_INSTANCE_ADDRESS = "102";
    public static final String SLOT_INSTANCE_ID = "100";
    public static final String SLOT_NAMESPACE = "101";
    public static final String SLOT_PRESET_NAME = "1";
    public static final String SLOT_REMOTE_SKIN_CLIENT = "2";
    public static final String SLOT_SESSION_TOKEN = "3";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static UUID getInstanceId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static IId getNamespace(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAMESPACE);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static String getPresetName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRESET_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CNodeAddress getRemoteSkinClient(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_REMOTE_SKIN_CLIENT);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setInstanceAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ADDRESS, slot);
    }

    public static void setInstanceId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ID, slot);
    }

    public static void setNamespace(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_NAMESPACE, slot);
    }

    public static void setPresetName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PRESET_NAME, slot);
    }

    public static void setRemoteSkinClient(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_REMOTE_SKIN_CLIENT, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }
}

