/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app;

import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.records.CRecordDataApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CApplicationDescription
implements IApplicationDescription,
Comparable<CApplicationDescription> {
    private final UUID mID;
    private final CStringProperties mDefaultProperties = new CStringProperties();
    private String mIconPath;
    private String mName;
    private String mShortDescription;
    private String mLongDescription;

    public CApplicationDescription(@NotNull CRecord aRecord) {
        CUtilCheck.checkNotNull((Object)aRecord, (String)"Record is null", (Object[])new Object[0]);
        CUtilCheck.checkEqual((Object)aRecord.getId(), (Object)CRecordDataApplication.ID, (String)"Wrong record type: this is not a %s", (Object[])new Object[]{CRecordDataApplication.class.getSimpleName()});
        this.mID = CRecordDataApplication.getId(aRecord, null);
        this.mIconPath = CRecordDataApplication.getIcon(aRecord, "");
        this.mLongDescription = CRecordDataApplication.getLongDescription(aRecord, "");
        this.mName = CRecordDataApplication.getName(aRecord, "");
        this.mShortDescription = CRecordDataApplication.getShortDescription(aRecord, "");
        CStringProperties defaultProperties = CRecordDataApplication.getDefaultProperties(aRecord, null);
        this.mDefaultProperties.addAll(defaultProperties);
    }

    public CApplicationDescription(@NotNull IApplicationDescription aDesc) {
        this.mID = aDesc.getAppId();
        this.mIconPath = aDesc.getIconPath();
        this.mName = aDesc.getName();
        this.mShortDescription = aDesc.getShortDescription();
        this.mLongDescription = aDesc.getLongDescription();
    }

    public CApplicationDescription(@NotNull UUID aID) {
        this.mID = aID;
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (!(aObj instanceof IApplicationDescription)) {
            return false;
        }
        IApplicationDescription other = (IApplicationDescription)aObj;
        return Objects.equals(this.mID, other.getAppId());
    }

    @Override
    @NotNull
    public UUID getAppId() {
        return this.mID;
    }

    @Override
    @NotNull
    public CStringProperties getDefaultProperties() {
        return this.mDefaultProperties;
    }

    @Override
    @NotNull
    public String getIconPath() {
        return this.mIconPath;
    }

    public void setIconPath(String aIconPath) {
        this.mIconPath = aIconPath;
    }

    @Override
    @NotNull
    public String getLongDescription() {
        return this.mLongDescription;
    }

    public void setLongDescription(@NotNull String aDesc) {
        this.mLongDescription = aDesc;
    }

    @Override
    @NotNull
    public String getName() {
        return this.mName;
    }

    public void setName(@NotNull String aName) {
        this.mName = aName;
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return this.mShortDescription;
    }

    public void setShortDescription(@NotNull String aDesc) {
        this.mShortDescription = aDesc;
    }

    public int hashCode() {
        return Objects.hash(this.mID);
    }

    @Override
    @NotNull
    public CRecord toRecord() throws CException {
        CRecord rec = CRecordDataApplication.create();
        CRecordDataApplication.setId(rec, this.mID);
        CRecordDataApplication.setLongDescription(rec, this.mLongDescription);
        CRecordDataApplication.setName(rec, this.mName);
        CRecordDataApplication.setShortDescription(rec, this.mShortDescription);
        CRecordDataApplication.setIcon(rec, this.mIconPath);
        CRecordDataApplication.setDefaultProperties(rec, this.mDefaultProperties);
        return rec;
    }

    @Override
    public int compareTo(@NotNull CApplicationDescription aOther) {
        return this.mName.compareTo(aOther.getName());
    }
}

