/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.preset;

import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.IReadOnlyStringProperties;
import java.util.Objects;
import java.util.UUID;

final class CApplicationPreset
implements IApplicationPreset {
    private final String mPresetName;
    private final UUID mApplicationID;
    private final CStringProperties mProperties;

    CApplicationPreset(String aPresetName, UUID aApplicationID, CStringProperties aProperties) {
        this.mPresetName = aPresetName;
        this.mApplicationID = aApplicationID;
        this.mProperties = aProperties;
    }

    public CApplicationPreset(IApplicationPreset aOther) {
        this.mApplicationID = aOther.getApplicationID();
        this.mPresetName = aOther.getPresetName();
        this.mProperties = new CStringProperties((IReadOnlyStringProperties)aOther.getProperties());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CApplicationPreset other = (CApplicationPreset)obj;
        return Objects.equals(this.mPresetName, other.mPresetName);
    }

    public UUID getApplicationID() {
        return this.mApplicationID;
    }

    public String getPresetName() {
        return this.mPresetName;
    }

    public CStringProperties getProperties() {
        return this.mProperties;
    }

    public int hashCode() {
        return Objects.hash(this.mPresetName);
    }

    public void setProperties(CStringProperties aProperties) {
        this.mProperties.addAll(aProperties);
    }

    public void removeProperty(String aPropertyKey) {
        this.mProperties.remove(aPropertyKey);
    }
}

