/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.manager;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.EShutDownMode;
import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationContext;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordAppRunApplication;
import de.sillysky.nyssr.app.records.CRecordAppStopApplication;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStarted;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.app.CUtilApplication;
import de.sillysky.nyssr.impl.app.IApplicationManager;
import de.sillysky.nyssr.impl.app.instance.registry.CAppInstanceEntry;
import de.sillysky.nyssr.impl.app.manager.CAppStarterTarget;
import de.sillysky.nyssr.impl.app.manager.CAppStopperTarget;
import de.sillysky.nyssr.impl.app.manager.CApplicationContext;
import de.sillysky.nyssr.impl.app.manager.CUtilSession;
import de.sillysky.nyssr.impl.app.manager.CUtilStopper;
import de.sillysky.nyssr.impl.app.manager.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.shutdown.records.CRecordNotifyShutdown;
import de.sillysky.nyssr.impl.shutdown.records.CRecordShutdownAddListener;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CApplicationManager
extends CTarget
implements IService,
IApplicationManager {
    private static final ILogger LOG = CLoggerFactory.getLogger(CApplicationManager.class);
    private final IDependencies mDependencies;

    public CApplicationManager(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAppRunApplication.ID, this::asyncStartApp);
        this.addMessageHandler(CRecordAppStopApplication.ID, this::asyncStopApp);
        this.addMessageHandler(CRecordNotifyShutdown.ID, this::asyncNotifyShutDown);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        INamespace ns = CUtilApplication.getOrCreateNamespace();
        ns.getTargetRegistry().registerTarget((ITarget)this);
        aServiceRegistry.registerService(IApplicationManager.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        INameDb nameDb = (INameDb)CServiceRegistry.getInstance().getService(INameDb.class);
        if (nameDb != null) {
            nameDb.getTargetAddressDatabase().putName(this.getAddress(), "AppManager");
        }
        this.mDependencies.getRecordHelper().addObserver(CRecordAppRunApplication.class, (ITarget)this, false);
        this.mDependencies.getRecordHelper().addObserver(CRecordAppStopApplication.class, (ITarget)this, false);
        this.mDependencies.getRecordHelper().addObserver(CRecordNotifyRemoteNodeRemoved.class, (ITarget)this, false);
        this.addShutdownListener();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartApp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String presetName = CRecordAppRunApplication.getPresetName((CRecord)aRecord, null);
        CUtilCheck.checkEmptyString((Object)presetName, (String)"Missing Preset Name.", (Object[])new Object[0]);
        CNodeAddress remoteSkinClient = CRecordAppRunApplication.getRemoteSkinClient((CRecord)aRecord, null);
        String sessionToken = CRecordAppRunApplication.getSessionToken((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)sessionToken, (String)"Missing Session Token", (Object[])new Object[0]);
        IApplicationPreset preset = this.mDependencies.getApplicationPresetRegistry().getPresetByName(presetName);
        CUtilCheck.checkNotNull((Object)preset, (String)"Preset %s not found.", (Object[])new Object[]{presetName});
        CStringProperties properties = preset.getProperties();
        CUtilCheck.checkNotNull((Object)properties, (String)"Properties are null.", (Object[])new Object[0]);
        String right = properties.get("mandatoryRight", "");
        aEnvelope.setBlocked(true);
        CAppStarterTarget target = new CAppStarterTarget(this.mDependencies, this, aEnvelope, aRecord, sessionToken, presetName, right, remoteSkinClient);
        this.getTargetRegistry().registerTarget((ITarget)target);
        return true;
    }

    private boolean asyncStopApp(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        aEnvelope.setBlocked(true);
        CAppStopperTarget target = new CAppStopperTarget(this.mDependencies, aEnvelope, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)target);
        return true;
    }

    private boolean asyncNotifyShutDown(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Collection apps = this.mDependencies.getApplicationInstanceRegistry().getAll();
        for (IApplicationInstance app : apps) {
            this.privateStopApplication(app.getInstanceId(), null);
        }
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws Exception {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        List list = this.mDependencies.getApplicationInstanceRegistry().getInstancesForNode(node);
        for (UUID instanceId : list) {
            this.privateStopApplication(instanceId, null);
        }
        return true;
    }

    @Nullable
    IApplicationInstance start(@NotNull CTargetAddress aOwner, @Nullable CNodeAddress aRemoteSkinClient, @NotNull String aPresetName, @NotNull String aSessionToken, @NotNull String aUserId) throws CException {
        CUtilCheck.checkNotNull((Object)aOwner, (String)"Owner address missing.", (Object[])new Object[0]);
        CUtilCheck.checkEmptyString((Object)aPresetName, (String)"Preset name is empty.", (Object[])new Object[0]);
        IApplicationPreset preset = this.mDependencies.getApplicationPresetRegistry().getPresetByName(aPresetName);
        CUtilCheck.checkNotNull((Object)preset, (String)"Preset %s not found.", (Object[])new Object[]{aPresetName});
        UUID applicationID = preset.getApplicationID();
        CUtilCheck.checkNotNull((Object)applicationID, (String)"Application ID is null.", (Object[])new Object[0]);
        CUtilCheck.checkTrue((boolean)CUtilUuid.isValid((UUID)applicationID), (String)"AppId %s isn't valid", (Object[])new Object[]{applicationID.toString()});
        CStringProperties properties = preset.getProperties();
        CUtilCheck.checkNotNull((Object)properties, (String)"Properties are null.", (Object[])new Object[0]);
        properties.put("owner.address", aOwner.valueToString());
        if (aRemoteSkinClient != null) {
            properties.put("remoteskin.address", aRemoteSkinClient.valueToString());
        }
        UUID instanceId = UUID.randomUUID();
        IApplicationFactory factory = this.mDependencies.getApplicationFactoryRegistry().getFactory(applicationID);
        if (factory == null) {
            throw new CException(5).append("Application ID ").append(applicationID.toString()).append(" is unknown. No Factory found.");
        }
        IId nid = this.privateGetNID(properties);
        INamespace namespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "AppPreset" + aPresetName);
        CUtilCheck.checkNotNull((Object)namespace, (String)"Can't create Namespace for starting Application %s.", (Object[])new Object[]{applicationID.toString()});
        IApplicationDescription desc = factory.getApplicationDescription();
        IApplicationInstance instance = this.mDependencies.getApplicationInstanceRegistry().registerInstance(desc, preset, instanceId, nid, CNodeAddress.getLocal(), namespace, aRemoteSkinClient, aSessionToken, aUserId);
        CApplicationContext applicationContext = this.privateCreateApplicationContext(instance, namespace);
        this.privateStartApplication(instanceId, factory, applicationContext, nid);
        this.privateSendNotifyApplicationInstanceStarted(instance);
        CUtilSession.logApps(this.mDependencies, LOG, instanceId, nid, instance, "started");
        return instance;
    }

    void exit(@NotNull UUID aInstanceId, @Nullable CResult aResult) throws Exception {
        this.privateStopApplication(aInstanceId, aResult);
    }

    void setProperty(@NotNull UUID aInstanceId, @NotNull String aKey, @Nullable String aValue) {
        CAppInstanceEntry entry = this.mDependencies.getInternalApplicationInstanceRegistry().getEntry(aInstanceId);
        if (entry != null) {
            entry.getProperties().put(aKey, aValue == null ? "" : aValue);
        }
    }

    private void privateStopApplication(UUID aInstanceId, CResult aResult) throws Exception {
        CUtilCheck.checkNotNull((Object)aInstanceId, (String)"InstanceId is null", (Object[])new Object[0]);
        CAppInstanceEntry entry = this.mDependencies.getInternalApplicationInstanceRegistry().getEntry(aInstanceId);
        if (entry == null) {
            throw new CException(5).append("Couldn't find the application instance ").append(aInstanceId.toString());
        }
        CUtilStopper.stopApplication(this.mDependencies, this, entry, EShutDownMode.FORCE, LOG, "SYSTEM");
    }

    private void privateStartApplication(UUID aInstanceId, IApplicationFactory aFactory, CApplicationContext aApplicationContext, IId aNid) throws CException {
        try {
            IApplication application = aFactory.start((IApplicationContext)aApplicationContext);
            this.mDependencies.getApplicationInstanceRegistry().setApplication(aInstanceId, application);
        }
        catch (Exception e) {
            this.mDependencies.getNamespaceFactory().deleteNamespace(aNid);
            throw new CException(24).append("Error starting the application").append((Object)e);
        }
    }

    private IId privateGetNID(CStringProperties aProperties) {
        String nidString = aProperties.get("app.nid", "");
        IId nid = CUtilString.isValid((String)nidString) ? CIdFactory.fromObject((Object)nidString) : CIdFactory.randomOfType((EIdType)EIdType.INT);
        return nid;
    }

    private void privateSendNotifyApplicationInstanceStarted(@NotNull IApplicationInstance aInstance) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordNotifyAppInstanceStarted.class);
        env.setSender(this.getAddress());
        CRecord rec1 = CRecordNotifyAppInstanceStarted.create();
        CRecord rec2 = aInstance.toRecord();
        CRecordNotifyAppInstanceStarted.setInstance((CRecord)rec1, (CRecord)rec2);
        this.sendNotification(env, rec1);
    }

    public void setInstanceTargetAddress(UUID aInstanceID, CTargetAddress aAddress) {
        CAppInstanceEntry entry = this.mDependencies.getInternalApplicationInstanceRegistry().getEntry(aInstanceID);
        if (entry != null) {
            entry.setTargetAddress(aAddress);
        }
    }

    private CApplicationContext privateCreateApplicationContext(@NotNull IApplicationInstance aInstance, @NotNull INamespace aNamespace) {
        return new CApplicationContext(this, aInstance, aNamespace);
    }

    private void addShutdownListener() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordShutdownAddListener.create();
        this.sendNotification(env, record);
    }
}

