/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.instance.registry;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationInstance;
import de.sillysky.nyssr.app.EAppInstanceStatus;
import de.sillysky.nyssr.app.IApplication;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.IReadOnlyStringProperties;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CAppInstanceEntry {
    private final AtomicLong mActivityCounter = new AtomicLong(0L);
    private final UUID mApplicationId;
    private final String mApplicationName;
    private final String mShortDescription;
    private final String mLongDescription;
    private final String mIconPath;
    private final String mPresetName;
    private final CStringProperties mPresetProperties;
    private final UUID mInstanceId;
    private final INamespace mNamespace;
    private final CNodeAddress mNodeAddress;
    private final IId mNID;
    private final CNodeAddress mRemoteSkinClientNode;
    private final String mSessionToken;
    private final String mUserId;
    private final CStringProperties mProperties;
    private EAppInstanceStatus mStatus;
    private CTargetAddress mTargetAddress;
    private LocalDateTime mStartTime;
    private IApplication mApplication;
    private long mTimeOfLastPing;

    CAppInstanceEntry(@NotNull IApplicationDescription aApplicationDescription, @NotNull IApplicationPreset aPreset, @NotNull UUID aInstanceId, @NotNull IId aNID, @NotNull CNodeAddress aNodeAddress, @NotNull INamespace aNamespace, @Nullable CNodeAddress aRemoteSkinClientNode, @NotNull String aSessionToken, @NotNull String aUserId) {
        this.mApplicationId = aApplicationDescription.getAppId();
        this.mApplicationName = aApplicationDescription.getName();
        this.mShortDescription = aApplicationDescription.getShortDescription();
        this.mLongDescription = aApplicationDescription.getLongDescription();
        this.mIconPath = aApplicationDescription.getIconPath();
        this.mPresetName = aPreset.getPresetName();
        this.mPresetProperties = aPreset.getProperties();
        this.mInstanceId = aInstanceId;
        this.mNodeAddress = aNodeAddress;
        this.mNID = aNID;
        this.mStatus = EAppInstanceStatus.STOPPED;
        this.mTargetAddress = null;
        this.mStartTime = LocalDateTime.now();
        this.mNamespace = aNamespace;
        this.mTimeOfLastPing = 0L;
        this.mRemoteSkinClientNode = aRemoteSkinClientNode;
        this.mSessionToken = aSessionToken;
        this.mUserId = aUserId;
        this.mProperties = new CStringProperties((IReadOnlyStringProperties)this.mPresetProperties);
    }

    public IApplication getApplication() {
        return this.mApplication;
    }

    void setApplication(IApplication aApplication) {
        this.mApplication = aApplication;
        this.start();
    }

    public long getActivityCounter() {
        return this.mActivityCounter.get();
    }

    public CTargetAddress getTargetAddress() {
        return this.mTargetAddress;
    }

    public void setTargetAddress(@Nullable CTargetAddress aAddress) {
        this.mTargetAddress = aAddress;
    }

    @NotNull
    public String getShortDescription() {
        return this.mShortDescription;
    }

    @NotNull
    public String getLongDescription() {
        return this.mLongDescription;
    }

    @NotNull
    public String getIconPath() {
        return this.mIconPath;
    }

    @NotNull
    public UUID getApplicationId() {
        return this.mApplicationId;
    }

    @NotNull
    public String getApplicationName() {
        return this.mApplicationName;
    }

    @NotNull
    public UUID getInstanceId() {
        return this.mInstanceId;
    }

    public IId getNID() {
        return this.mNID;
    }

    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    @Nullable
    public INamespace getNamespace() {
        return this.mNamespace;
    }

    @NotNull
    public String getPresetName() {
        return this.mPresetName;
    }

    @NotNull
    public CStringProperties getPresetProperties() {
        return this.mPresetProperties;
    }

    @NotNull
    public CStringProperties getProperties() {
        return this.mProperties;
    }

    @NotNull
    public EAppInstanceStatus getStatus() {
        return this.mStatus;
    }

    public void setStatus(EAppInstanceStatus aStatus) {
        this.mStatus = aStatus;
    }

    @NotNull
    public LocalDateTime getTimeStarted() {
        return this.mStartTime;
    }

    public long getTimeOfLastPing() {
        return this.mTimeOfLastPing;
    }

    public void notifyPing() {
        this.mTimeOfLastPing = System.currentTimeMillis();
    }

    public void setProperty(@NotNull String aKey, @NotNull String aValue) {
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void start() {
        this.mStatus = EAppInstanceStatus.RUNNING;
        this.mStartTime = LocalDateTime.now();
    }

    public void stop() {
        this.mStatus = EAppInstanceStatus.STOPPING;
    }

    @NotNull
    public CRecord toRecord() throws CException {
        return this.getInstance().toRecord();
    }

    @Nullable
    public CNodeAddress getRemoteSkinClientNode() {
        return this.mRemoteSkinClientNode;
    }

    @NotNull
    public IApplicationInstance getInstance() {
        return new CApplicationInstance(this.mApplicationId, this.mApplicationName, this.mShortDescription, this.mLongDescription, this.mIconPath, this.mPresetName, this.mPresetProperties, this.mInstanceId, this.mNID, this.mNodeAddress, this.mStartTime, this.mRemoteSkinClientNode, this.mTargetAddress, this.mActivityCounter.get(), this.mStatus, this.mSessionToken, this.mUserId);
    }

    public String toString() {
        return this.mApplicationName + " AppInstanceId=" + this.mInstanceId + " status=" + this.mStatus + " Address=" + this.mTargetAddress;
    }
}

