/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.registry;

import de.sillysky.nyssr.app.CApplicationDescription;
import de.sillysky.nyssr.app.IApplicationDescription;
import de.sillysky.nyssr.app.IApplicationFactory;
import de.sillysky.nyssr.app.IApplicationFactoryRegistry;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.app.factory.registry.CAppFactoryEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class CAppFactoryRegistry
implements IApplicationFactoryRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppFactoryRegistry.class);
    private final Map<UUID, CAppFactoryEntry> mAppFactories = new ConcurrentHashMap<UUID, CAppFactoryEntry>();

    CAppFactoryRegistry() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IApplicationFactoryRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public boolean deregisterFactory(@NotNull IApplicationFactory aFactory) {
        CUtilCheck.checkNotNull((Object)aFactory, (String)"Factory is null", (Object[])new Object[0]);
        IApplicationDescription description = aFactory.getApplicationDescription();
        CUtilCheck.checkTrue((description != null ? 1 : 0) != 0, (String)"Factory has no application description", (Object[])new Object[0]);
        assert (description != null);
        UUID appId = description.getAppId();
        CAppFactoryEntry removed = this.mAppFactories.remove(appId);
        if (removed != null) {
            LOG.debug("AppFactory {} removed.", new Object[]{appId});
            return true;
        }
        LOG.warn("Application Factory {} not removed because not found", new Object[]{appId});
        return false;
    }

    public IApplicationDescription getDescriptionByID(@NotNull UUID aApplicationID) {
        CUtilCheck.checkNotNull((Object)aApplicationID, (String)"ApplicationID is null", (Object[])new Object[0]);
        CAppFactoryEntry entry = this.mAppFactories.get(aApplicationID);
        return entry == null ? null : entry.getDescription();
    }

    @NotNull
    public List<IApplicationFactory> getFactories() {
        ArrayList<IApplicationFactory> list = new ArrayList<IApplicationFactory>();
        for (CAppFactoryEntry entry : this.mAppFactories.values()) {
            list.add(entry.getFactory());
        }
        return list;
    }

    public IApplicationFactory getFactory(@NotNull UUID aAppId) {
        CAppFactoryEntry entry = this.mAppFactories.get(aAppId);
        if (entry == null) {
            return null;
        }
        return entry.getFactory();
    }

    @NotNull
    public Collection<IApplicationDescription> getSupportedApplications() {
        ArrayList<IApplicationDescription> list = new ArrayList<IApplicationDescription>();
        for (CAppFactoryEntry e : this.mAppFactories.values()) {
            IApplicationDescription d1 = e.getDescription();
            CApplicationDescription d2 = new CApplicationDescription(d1);
            list.add((IApplicationDescription)d2);
        }
        return list;
    }

    public boolean registerFactory(@NotNull IApplicationFactory aFactory) {
        CUtilCheck.checkNotNull((Object)aFactory, (String)"Factory is null", (Object[])new Object[0]);
        IApplicationDescription description = aFactory.getApplicationDescription();
        CUtilCheck.checkTrue((description != null ? 1 : 0) != 0, (String)"Factory has no application descriptions", (Object[])new Object[0]);
        assert (description != null);
        UUID id = description.getAppId();
        CUtilCheck.checkNotNull((Object)id, (String)"Id is null", (Object[])new Object[0]);
        CUtilCheck.checkEmptyString((Object)description.getName(), (String)"Name is empty", (Object[])new Object[0]);
        CUtilCheck.checkEmptyString((Object)description.getLongDescription(), (String)"Long description is empty", (Object[])new Object[0]);
        CUtilCheck.checkEmptyString((Object)description.getShortDescription(), (String)"Short description is empty", (Object[])new Object[0]);
        if (!this.mAppFactories.containsKey(id)) {
            CAppFactoryEntry entry = new CAppFactoryEntry(aFactory, description);
            this.mAppFactories.put(id, entry);
            LOG.info("Application Factory registered: Name={}, ID={}", new Object[]{description.getName(), id});
            this.dump();
            return true;
        }
        LOG.warn("Application Factory already registered: Name={}, ID={}", new Object[]{description.getName(), id});
        return false;
    }

    @NotNull
    public String getIconPath(@NotNull UUID aId) {
        IApplicationDescription desc = this.getDescriptionByID(aId);
        return desc == null ? "" : desc.getIconPath();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append(this.getClass().getSimpleName());
        sb.append(" (");
        sb.append(this.mAppFactories.size());
        sb.append(" factories)");
        TreeSet<String> tree = new TreeSet<String>();
        StringBuilder sb2 = new StringBuilder(100);
        for (CAppFactoryEntry e : this.mAppFactories.values()) {
            IApplicationDescription d = e.getDescription();
            sb2.append("    ");
            sb2.append(d.getName());
            sb2.append(" (");
            sb2.append(d.getAppId());
            sb2.append(")");
            sb2.append(CUtilString.CRLF);
            tree.add(sb2.toString());
            sb2.setLength(0);
        }
        for (String s : tree) {
            sb.append(s);
        }
        return sb.toString();
    }

    private void dump() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(2000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("= Application Factories:\n");
            for (CAppFactoryEntry e : this.mAppFactories.values()) {
                IApplicationDescription desc = e.getDescription();
                sb.append(String.format("= %-8.8s", CUtilUuid.toShortString((UUID)desc.getAppId())));
                sb.append(String.format("%-30.30s", desc.getName()));
                sb.append(desc.getShortDescription());
                sb.append(CUtilString.CRLF);
            }
            sb.append(CUtilString.LINE_CRLF);
            LOG.debug(sb.toString());
        }
    }
}

