/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.autostart;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.app.IApplicationPreset;
import de.sillysky.nyssr.app.records.CRecordAppRunApplication;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.app.CUtilApplication;
import de.sillysky.nyssr.impl.app.autostart.CAutoStartEntry;
import de.sillysky.nyssr.impl.app.autostart.CRecordAutoStartTimer;
import de.sillysky.nyssr.impl.app.autostart.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

final class CTargetApplicationAutoStart
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetApplicationAutoStart.class);
    private static final long TIMEOUT = 1000L;
    private final Map<UUID, CAutoStartEntry> mPresetEntries = new HashMap<UUID, CAutoStartEntry>();
    private final IDependencies mDependencies;
    private CTimer mTimer;
    private int mCounter;

    public CTargetApplicationAutoStart(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.load();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAutoStartTimer.ID, this::asyncAutoStartTimer);
        this.addMessageHandler(CRecordAppRunApplication.ID, this::asyncAnswerRunApplication);
        INamespace ns = CUtilApplication.getOrCreateNamespace();
        ITargetRegistry targetRegistry = ns.getTargetRegistry();
        targetRegistry.registerTarget((ITarget)this, CWellKnownTID.APP_AUTO_START);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mTimer.dismiss();
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(this.getAddress(), "AppAutoStart");
        this.check();
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), CRecordAutoStartTimer.ID, this.getAddress(), 1000L, false, null);
        this.mTimer.startIf();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAutoStartTimer(CEnvelope aEnvelope, CRecord aRecord) {
        this.mTimer.notifyTriggerOccurred();
        ++this.mCounter;
        if (this.mCounter > 120) {
            this.mTimer.setDelay(5000L);
        }
        if (!this.check()) {
            this.deregisterTarget();
        } else {
            this.mTimer.startIf();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAnswerRunApplication(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            UUID transactionId = aEnvelope.getTransactionId();
            if (result.hasSuccess()) {
                this.mPresetEntries.remove(transactionId);
            } else {
                CAutoStartEntry e = this.mPresetEntries.get(transactionId);
                if (e != null) {
                    e.setStarted(false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean check() {
        for (CAutoStartEntry e : this.mPresetEntries.values()) {
            if (!e.shouldStart()) continue;
            String presetName = e.getPreset().getPresetName();
            try {
                e.setStarted(true);
                this.sendStartApplication(presetName);
            }
            catch (CException e0) {
                if (e0.getCode() == 5) {
                    LOG.warn(e0.getMessage());
                    continue;
                }
                LOG.error((Throwable)e0, "Error starting APP Preset {}", new Object[]{presetName});
            }
            catch (Throwable e1) {
                LOG.error(e1, "Error starting APP Preset {}", new Object[]{presetName});
            }
        }
        return !this.mPresetEntries.isEmpty();
    }

    private void sendStartApplication(@NotNull String aPresetName) throws CException {
        CEnvelope env = new CEnvelope();
        CRecord record = CRecordAppRunApplication.create();
        CRecordAppRunApplication.setSessionToken((CRecord)record, null);
        CRecordAppRunApplication.setPresetName((CRecord)record, (String)aPresetName);
        CRecordAppRunApplication.setRemoteSkinClient((CRecord)record, (CNodeAddress)this.getAddress().getNodeAddress());
        this.sendRequest(env, record);
    }

    private void load() {
        Collection<IApplicationPreset> presets = this.mDependencies.getApplicationPresetRegistry().getPresets();
        LocalDateTime now = LocalDateTime.now();
        for (IApplicationPreset dto : presets) {
            long timeDiff;
            String value;
            CStringProperties sp = dto.getProperties();
            if (sp == null || (value = sp.get("auto_start.seconds.after.node")) == null || (timeDiff = CUtilLong.fromString((String)value, (long)-1L)) < 0L) continue;
            CAutoStartEntry e = new CAutoStartEntry(dto, now.plusSeconds(timeDiff));
            this.mPresetEntries.put(e.getTransactionId(), e);
        }
    }
}

