/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.server.dialog;

import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.CUtilDialogHelper;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordNotifyDialogClosed2;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class CBasicDialogFactory
extends CTarget
implements IService {
    private final Map<UUID, CBasicDialog> mChildren = new HashMap<UUID, CBasicDialog>();

    public CBasicDialogFactory() {
        this.addMessageHandler(CRecordNotifyDialogClosed2.ID, this::asyncNotifyDialogClosed);
    }

    private boolean asyncNotifyDialogClosed(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CBasicDialog removed;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID id = CRecordNotifyDialogClosed2.getId(aRecord, null);
        if (id != null && (removed = this.mChildren.remove(id)) != null) {
            this.dump("removed");
        }
        return true;
    }

    protected CDialogDto checkStartDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return CUtilDialogHelper.convertRecordToDto(aEnvelope, aRecord, this.getAddress());
    }

    protected void addDialog(@NotNull CBasicDialog aDialog) {
        this.mChildren.put(aDialog.getDialogDto().getDialogInstanceId(), aDialog);
        this.dump("added");
    }

    protected void dump(@NotNull String aAction) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append(CUtilString.LINE_CRLF);
        sb.append("Dialog ").append(this.getDialogName()).append(" ").append(aAction).append(", currently ").append(this.mChildren.size()).append(" ").append(this.getDialogName()).append(" Dialog(s) running.").append(CUtilString.CRLF);
        sb.append(String.format("%40s %30s %60s %30s\n", "ADDRESS", "CLIENT CONTEXT ADDRESS", "CLIENT CONTEXT ID", "OWNER ADDRESS"));
        for (CBasicDialog child : this.mChildren.values()) {
            CDialogDto dto = child.getDialogDto();
            IRemoteSkinClientContext clientContext = dto.getClientContext();
            sb.append(String.format("%40s %30s %60s %30s\n", child.getAddress(), clientContext.getTargetAddress(), clientContext.getId(), dto.getOwnerAddress()));
        }
        sb.append(CUtilString.LINE_CRLF);
        this.getLogger().debug(sb.toString());
    }

    @NotNull
    protected abstract String getDialogName();

    @NotNull
    protected abstract ILogger getLogger();

    protected Collection<CBasicDialog> getChildren() {
        return this.mChildren.values();
    }
}

