/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.registry;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactory;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactoryRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class CWidgetRegistry
implements IWidgetFactoryRegistry,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetRegistry.class);
    private final Map<String, IWidgetFactory> mFactories = new ConcurrentHashMap<String, IWidgetFactory>();

    CWidgetRegistry() {
    }

    static void getDependencies(IServiceDependencyList aDependencyList) {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IWidgetFactoryRegistry.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    public void deregisterFactory(@NotNull IWidgetFactory aFactory) {
        ArrayList<String> types = new ArrayList<String>();
        for (Map.Entry<String, IWidgetFactory> entry : this.mFactories.entrySet()) {
            if (aFactory != entry.getValue()) continue;
            types.add(entry.getKey());
        }
        for (String type : types) {
            this.deregisterFactory(type);
        }
    }

    public void deregisterFactory(@NotNull String aWidgetType) {
        LOG.debug("Deregister factory for {}", new Object[]{aWidgetType});
        this.mFactories.remove(aWidgetType.toLowerCase());
    }

    public IWidgetFactory get(@NotNull String aType) {
        return this.mFactories.get(aType.toLowerCase());
    }

    public void registerFactory(@NotNull String aWidgetType, @NotNull IWidgetFactory aFactory) {
        LOG.debug("Register factory for {}", new Object[]{aWidgetType});
        this.mFactories.put(aWidgetType.toLowerCase(), aFactory);
    }
}

