/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.widget.parser.raw;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CExceptionLogger;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CRawWidgetSet;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CUtilHierarchyParser;
import de.sillysky.nyssr.impl.remoteskin.widget.parser.raw.CWidgetParser;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeTemplateList;
import de.sillysky.nyssr.remoteskin.model.keys.EWidgetSetJsonKeys;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.widget.parser.IRemoteSkinRawJsonParser;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CRemoteSkinRawJsonParser
implements IService,
IRemoteSkinRawJsonParser {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinRawJsonParser.class);
    private IJsonParser mJsonParser;

    static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IJsonParser.class);
    }

    public CRawWidgetSet parse(@NotNull String aJson) throws CException {
        CAttributeTemplateList templateList = new CAttributeTemplateList();
        CRawWidgetSet widgetSet = new CRawWidgetSet();
        CJsonObject root = this.mJsonParser.parse(aJson, true);
        this.parseWidgetSetHeader(widgetSet, root);
        this.parseTemplates(templateList, root);
        this.parseWidgets(widgetSet, templateList, root);
        this.parseHierarchy(widgetSet, root);
        return widgetSet;
    }

    private void parseTemplates(@NotNull CAttributeTemplateList aTemplateList, @NotNull CJsonObject aRoot) throws CException {
        LOG.debug("Parse Templates");
        Object o1 = aRoot.getValue(EWidgetSetJsonKeys.Templates.name());
        if (o1 == null) {
            return;
        }
        if (o1 instanceof CJsonObject) {
            CJsonObject jsonObject = (CJsonObject)o1;
            Collection keys = jsonObject.keys();
            for (String key : keys) {
                LOG.debug("Found Template {}", new Object[]{key});
                String keyLower = key.trim().toLowerCase();
                CJsonObject child = (CJsonObject)jsonObject.getValue(key);
                if (child == null) continue;
                aTemplateList.addTemplate(keyLower, child);
            }
        } else {
            CExceptionLogger.logAndThrow(this.getClass(), (int)2105, (String)"{0} is no JSON Object", (Object[])new Object[]{EWidgetSetJsonKeys.Templates.name()});
        }
    }

    private void parseWidgetSetHeader(@NotNull CRawWidgetSet aWidgetSet, @NotNull CJsonObject aRoot) throws CException {
        LOG.debug("Parse WidgetSet");
        Object o = aRoot.getValue(EWidgetSetJsonKeys.WidgetSet.name());
        if (o instanceof CJsonObject) {
            CJsonObject widgetHeader = (CJsonObject)o;
            Object o1 = widgetHeader.getValue("widgetsetname");
            if (o1 instanceof String) {
                String name = (String)o1;
                aWidgetSet.setName(name);
            } else {
                CExceptionLogger.logAndThrow(this.getClass(), (int)2105, (String)"No attribute {0} found in {1}", (Object[])new Object[]{"widgetsetname", EWidgetSetJsonKeys.WidgetSet.name()});
            }
            Object value = widgetHeader.getValue("instanceid");
            String instanceId = CUtilString.fromObject((Object)value, (String)"");
            assert (instanceId != null);
            aWidgetSet.setInstanceIdFromJson(instanceId);
        } else {
            CExceptionLogger.logAndThrow(this.getClass(), (int)2105, (String)"No JSON Object {0} found", (Object[])new Object[]{EWidgetSetJsonKeys.WidgetSet.name()});
        }
    }

    private void parseWidgets(@NotNull CRawWidgetSet aWidgetSet, @NotNull CAttributeTemplateList aTemplateList, @NotNull CJsonObject aRoot) throws CException {
        LOG.debug("Parse Widgets");
        Object value = aRoot.getValue(EWidgetSetJsonKeys.Widgets.name());
        if (value instanceof CJsonArray) {
            CWidgetParser.parse(aWidgetSet.getWidgetEntries(), aTemplateList, (CJsonArray)value);
        } else {
            CExceptionLogger.logAndThrow(this.getClass(), (int)2105, (String)"No JSON Array {0} found", (Object[])new Object[]{EWidgetSetJsonKeys.Widgets.name()});
        }
    }

    private void parseHierarchy(@NotNull CRawWidgetSet aWidgetSet, @NotNull CJsonObject aRoot) throws CException {
        Object o2 = aRoot.getValue(EWidgetSetJsonKeys.Hierarchy.name());
        if (o2 instanceof CJsonObject) {
            CUtilHierarchyParser.parse(aWidgetSet.getWidgetEntries(), (CJsonObject)o2, aWidgetSet.getName());
        } else {
            CExceptionLogger.logAndThrow(this.getClass(), (int)2105, (String)"No JSON Object {0} found", (Object[])new Object[]{EWidgetSetJsonKeys.Hierarchy.name()});
        }
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mJsonParser = (IJsonParser)aServiceRegistry.getService(IJsonParser.class);
        aServiceRegistry.registerService(IRemoteSkinRawJsonParser.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }
}

