/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.server.dialogflavor;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.server.dialogflavor.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.dialog.monitor.CConstantsDialogMonitor;
import de.sillysky.nyssr.remoteskin.dialog.monitor.records.CRecordNotifyDialogClosed;
import de.sillysky.nyssr.remoteskin.dialog.monitor.records.CRecordNotifyDialogOpened;
import de.sillysky.nyssr.remoteskin.model.EPlatformType;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialog.records.CRecordCloseDialog;
import de.sillysky.nyssr.remoteskin.server.dialoghelper.IDialogFlavor;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CDialogFlavor
implements IDialogFlavor {
    private final IDependencies mDependencies;
    private final CDialogDto mDialogDto;
    private CTarget mTarget;
    @NotNull
    private String[] mJsonFiles;

    CDialogFlavor(@NotNull IDependencies aDependencies, @NotNull CDialogDto aDialogDto) {
        this.mDependencies = aDependencies;
        this.mDialogDto = aDialogDto;
    }

    public void initialize(@NotNull CTarget aTarget, @NotNull String[] aJsonFiles) {
        this.mTarget = aTarget;
        this.mJsonFiles = aJsonFiles;
        this.mTarget.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.mTarget.addMessageHandler(CRecordCloseDialog.ID, this::asyncCloseDialog);
        this.mTarget.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CTargetAddress address = this.mTarget.getAddress();
        INamespace ns = this.mDependencies.getNamespaceRegistry().getNamespace(CWellKnownNID.SYSTEM);
        assert (ns != null);
        INanoServiceRegistry nsr = ns.getNanoServiceRegistry();
        nsr.addObserver(CRecordNotifyRemoteNodeRemoved.class, address, false);
        IRemoteSkinServerContext serverContext = this.mDependencies.getServerContextFactory().createContext(this.mDialogDto.getClientContext(), address.getNID());
        this.mDialogDto.setServerContext(serverContext);
        this.sendJsonFiles();
        this.registerDialog();
        this.mTarget.getDismissListenerSupport().addListener(aDismissedObject -> {
            if (aDismissedObject == this.mTarget) {
                this.unregisterDialog();
            }
        });
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        if (node != null) {
            boolean b1 = this.mDialogDto.getClientContext().getTargetAddress().getNodeAddress().equals((Object)node);
            boolean b2 = this.mDialogDto.getOwnerAddress().getNodeAddress().equals((Object)node);
            if (b1 || b2) {
                this.mTarget.deregisterTarget();
            }
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncCloseDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTarget.deregisterTarget();
        aEnvelope.setResultSuccess();
        return true;
    }

    protected void sendJsonFiles() throws CException {
        if (this.mJsonFiles != null && this.mJsonFiles.length > 0) {
            ArrayList<String> jsonList = new ArrayList<String>();
            for (String jsonName : this.mJsonFiles) {
                String json = this.mDependencies.getWidgetSetLoader().loadJson(this.getClass(), jsonName);
                jsonList.add(json);
            }
            this.mDialogDto.getServerContext().pushWidgetSets(jsonList, null);
        }
    }

    @NotNull
    public CDialogDto getDialogDto() {
        return this.mDialogDto;
    }

    private void registerDialog() throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsDialogMonitor.MICRO_SERVICE_ID);
        CRecord record = CRecordNotifyDialogOpened.create();
        CRecordNotifyDialogOpened.setId((CRecord)record, (UUID)this.mDialogDto.getDialogInstanceId());
        CRecordNotifyDialogOpened.setDialogType((CRecord)record, (String)"DialogMonitor");
        CRecordNotifyDialogOpened.setClientContextAddress((CRecord)record, (CTargetAddress)this.mDialogDto.getClientContext().getTargetAddress());
        CRecordNotifyDialogOpened.setClientContextId((CRecord)record, (IId)this.mDialogDto.getClientContext().getId());
        CRecordNotifyDialogOpened.setPlatformType((CRecord)record, (String)EPlatformType.SWING.name());
        CRecordNotifyDialogOpened.setParentWidgetId((CRecord)record, (CWidgetId)this.mDialogDto.getParentWidgetId());
        CRecordNotifyDialogOpened.setSessionToken((CRecord)record, (String)this.mDialogDto.getSessionToken());
        this.mTarget.sendNotification(env, record);
    }

    private void unregisterDialog() throws CException {
        CEnvelope env = CEnvelope.forMicroService((IId)CConstantsDialogMonitor.MICRO_SERVICE_ID);
        CRecord record = CRecordNotifyDialogClosed.create();
        CRecordNotifyDialogClosed.setId((CRecord)record, (UUID)this.mDialogDto.getDialogInstanceId());
        this.mTarget.sendNotification(env, record);
    }
}

