/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.string;

import de.sillysky.nyssr.util.CUtilString;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilBase64 {
    public static final String PREFIX = "^";

    private CUtilBase64() {
    }

    @NotNull
    public static String encodeToString(byte[] aBytes) {
        return Base64.getEncoder().encodeToString(aBytes);
    }

    @NotNull
    public static String encodeToStringWithPrefix(byte[] aBytes) {
        return PREFIX + Base64.getEncoder().encodeToString(aBytes);
    }

    @NotNull
    public static String encodeToStringWithPrefix(@NotNull String aString) {
        return PREFIX + Base64.getEncoder().encodeToString(aString.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] decode(@NotNull String aBase64) {
        return Base64.getDecoder().decode(aBase64);
    }

    @Nullable
    public static String decodeString(@Nullable String aText) {
        String out = aText;
        if (CUtilString.isValid(out) && aText.startsWith(PREFIX) && aText.length() % 4 == 1) {
            try {
                byte[] bytes = CUtilBase64.decode(aText.substring(1));
                out = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException iae) {
                out = aText;
            }
        }
        return out;
    }

    @Nullable
    public static String decodeStringWithoutPrefix(@Nullable String aText) {
        String out = aText;
        if (CUtilString.isValid(out) && aText.length() % 4 == 0) {
            try {
                byte[] bytes = CUtilBase64.decode(aText);
                out = new String(bytes, StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException iae) {
                out = aText;
            }
        }
        return out;
    }
}

