/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

public enum EHashType {
    EMPTY(0),
    MD2(1),
    MD5(2),
    SHA1(3),
    SHA256(4),
    SHA384(5),
    SHA512(6);

    private final byte mValue;

    public static EHashType get(byte aValue) {
        EHashType[] arr = EHashType.values();
        if (aValue >= 0 && aValue < arr.length) {
            return arr[aValue];
        }
        return EMPTY;
    }

    public static EHashType getSave(byte aValue) {
        EHashType result;
        switch (aValue) {
            case 1: {
                result = MD2;
                break;
            }
            case 2: {
                result = MD5;
                break;
            }
            case 3: {
                result = SHA1;
                break;
            }
            case 4: {
                result = SHA256;
                break;
            }
            case 5: {
                result = SHA384;
                break;
            }
            case 6: {
                result = SHA512;
                break;
            }
            default: {
                result = EMPTY;
            }
        }
        return result;
    }

    private EHashType(byte aValue) {
        this.mValue = aValue;
    }

    public byte getValue() {
        return this.mValue;
    }
}

