/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.array;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.array.IFromStream;
import de.sillysky.nyssr.util.array.IStringByIndex;
import de.sillysky.nyssr.util.array.IToStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilArray {
    public static final int NULL_VALUE = -1;

    private CUtilArray() {
    }

    @NotNull
    public static <T> @NotNull T @NotNull [] copyWithoutNullElements(T @NotNull [] aArray) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : aArray) {
            if (t == null) continue;
            list.add(t);
        }
        Object[] arr0 = (Object[])Array.newInstance(aArray.getClass().getComponentType(), 0);
        return list.toArray(arr0);
    }

    public static <T> int countNotNull(@Nullable T[] aArray) {
        int count = 0;
        if (aArray != null) {
            for (T t : aArray) {
                if (t == null) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> int countNull(@Nullable T[] aArray) {
        int count = 0;
        if (aArray != null) {
            for (T t : aArray) {
                if (t != null) continue;
                ++count;
            }
        }
        return count;
    }

    public static <T> void toStream(@NotNull DataOutput aStream, @Nullable T[] aArray, IToStream<T> aStreamer) throws IOException {
        if (aArray == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aArray.length + 1);
            for (T t : aArray) {
                aStreamer.toStream(aStream, t);
            }
        }
    }

    public static <T> T @Nullable [] fromStream(@NotNull DataInput aStream, @Nullable Class<?> aClass, IFromStream<T> aStreamer) throws IOException {
        int length = CPositiveInteger.fromStream(aStream);
        if (length == 0) {
            return null;
        }
        Object[] arr = (Object[])Array.newInstance(aClass, length - 1);
        for (int i = 0; i < length - 1; ++i) {
            arr[i] = aStreamer.fromStream(aStream);
        }
        return arr;
    }

    @NotNull
    public static <T> String toString(@Nullable T[] aValue, int aPos, int aLength, char aDelimiter, int aMaxLen, @NotNull Function<T, String> aFunction) {
        if (aValue == null) {
            return "null";
        }
        if (aValue.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(500);
        boolean first = true;
        for (int pos = aPos; pos < aPos + aLength; ++pos) {
            if (first) {
                first = false;
            } else {
                sb.append(aDelimiter);
            }
            sb.append(aFunction.apply(aValue[pos]));
            if (aMaxLen > 0 && sb.length() >= aMaxLen) break;
        }
        if (aMaxLen > 0 && sb.length() > aMaxLen) {
            sb.setLength(aMaxLen);
        }
        return sb.toString();
    }

    @NotNull
    public static String toString(int aStartIndex, char aDelimiter, int aMaxLen, @NotNull IStringByIndex aSupplier) {
        String value;
        StringBuilder sb = new StringBuilder(500);
        boolean first = true;
        int index = aStartIndex;
        while (!"\uf00bE".equals(value = aSupplier.getString(index))) {
            if (!"\uf00bF".equals(value)) {
                if (value == null) {
                    value = "null";
                }
                if (first) {
                    first = false;
                } else if (aDelimiter != '\u0000') {
                    sb.append(aDelimiter);
                }
                sb.append(value);
                if (aMaxLen > 0 && sb.length() >= aMaxLen) break;
            }
            ++index;
        }
        if (aMaxLen > 0 && sb.length() > aMaxLen) {
            sb.setLength(aMaxLen);
        }
        return sb.toString();
    }
}

