/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.job.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordAddJobEngineThread
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("5a75a266-303a-44da-9e33-47db05841678");
    public static final String NAME = "AddJobEngineThread";
    public static final String DESCRIPTION = "Add a thread.";
    public static final String SLOT_MAX_JOBS = "3";
    public static final String SLOT_NAME = "1";
    public static final String SLOT_PRIORITY = "2";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static int getMaxJobs(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MAX_JOBS);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static String getName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static int getPriority(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PRIORITY);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static void setMaxJobs(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_MAX_JOBS, slot);
    }

    public static void setName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_NAME, slot);
    }

    public static void setPriority(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_PRIORITY, slot);
    }
}

