/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.target.monitor;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.address.filter.CTargetAddressFilter;
import de.sillysky.nyssr.address.filter.CUtilTargetAddressFilter;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import de.sillysky.nyssr.target.monitor.ITargetMonitor;
import de.sillysky.nyssr.target.monitor.records.CRecordTargetMonitorNotifyTargetDeregistered;
import de.sillysky.nyssr.target.monitor.records.CRecordTargetMonitorNotifyTargetRegistered;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CTargetMonitor
implements ITargetMonitor {
    private static final UUID REQUESTER_ID = UUID.randomUUID();
    private final Map<CTargetAddress, Set<CTargetAddressFilter>> mFilter = new HashMap<CTargetAddress, Set<CTargetAddressFilter>>();
    private final CTargetAddress mMyAddress;
    private final IMessageSender mMessageSender;
    private final IListenerRegistry mListenerRegistry;

    public CTargetMonitor(@NotNull IMessageSender aMessageSender, @NotNull IListenerRegistry aListenerRegistry, @NotNull CNamespaceAddress aNamespaceAddress) {
        this.mMessageSender = aMessageSender;
        this.mListenerRegistry = aListenerRegistry;
        this.mMyAddress = new CTargetAddress(CWellKnownTID.TARGET_MONITOR, aNamespaceAddress);
        CStringProperties sp = new CStringProperties();
        sp.put("nid", aNamespaceAddress.getNID().valueToString());
        CServiceRegistry.getInstance().registerService(ITargetMonitor.class, sp, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(@NotNull CTargetAddress aObserver, @NotNull CTargetAddressFilter aFilter) {
        this.mListenerRegistry.addAddress(REQUESTER_ID, aObserver);
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            Set set = this.mFilter.computeIfAbsent(aObserver, k -> new HashSet());
            set.add(aFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(@NotNull CTargetAddress aObserver, CTargetAddressFilter @NotNull [] aFilters) {
        this.mListenerRegistry.addAddress(REQUESTER_ID, aObserver);
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            Set set = this.mFilter.computeIfAbsent(aObserver, k -> new HashSet());
            set.addAll(Arrays.asList(aFilters));
        }
    }

    public void deactivate() {
        CServiceRegistry.getInstance().deregisterService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<CTargetAddress> privateFilter(CTargetAddress aInput) {
        HashSet<CTargetAddress> observers = new HashSet<CTargetAddress>();
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            this.privateUpdate();
            this.mFilter.forEach((key, value) -> {
                if (CUtilTargetAddressFilter.filter(aInput, value)) {
                    observers.add((CTargetAddress)key);
                }
            });
        }
        return observers;
    }

    private void privateUpdate() {
        this.mFilter.entrySet().removeIf(e -> !this.mListenerRegistry.hasAddress(REQUESTER_ID, (CTargetAddress)e.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(@NotNull CTargetAddress aObserver, @NotNull CTargetAddressFilter aFilter) {
        boolean empty = false;
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            Set<CTargetAddressFilter> filter = this.mFilter.get(aObserver);
            if (filter != null) {
                filter.remove(aFilter);
                if (filter.isEmpty()) {
                    this.mFilter.remove(aObserver);
                    empty = true;
                }
            } else {
                empty = true;
            }
        }
        if (empty) {
            this.mListenerRegistry.removeAddress(REQUESTER_ID, aObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(@NotNull CTargetAddress aObserver, CTargetAddressFilter @NotNull [] aFilters) {
        boolean empty = false;
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            Set<CTargetAddressFilter> filter = this.mFilter.get(aObserver);
            if (filter != null) {
                Arrays.asList(aFilters).forEach(filter::remove);
                if (filter.isEmpty()) {
                    this.mFilter.remove(aObserver);
                    empty = true;
                }
            } else {
                empty = true;
            }
        }
        if (empty) {
            this.mListenerRegistry.removeAddress(REQUESTER_ID, aObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(@NotNull CTargetAddress aObserver) {
        Map<CTargetAddress, Set<CTargetAddressFilter>> map = this.mFilter;
        synchronized (map) {
            this.mFilter.remove(aObserver);
        }
        this.mListenerRegistry.removeAddress(REQUESTER_ID, aObserver);
    }

    public void triggerTargetRemoved(@NotNull CTargetAddress aAddress, @NotNull String aName) {
        Collection<CTargetAddress> observers = this.privateFilter(aAddress);
        for (CTargetAddress a : observers) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget(a);
                env.setSender(this.mMyAddress);
                CRecord record = CRecordTargetMonitorNotifyTargetDeregistered.create();
                CRecordTargetMonitorNotifyTargetDeregistered.setAddress(record, aAddress);
                CRecordTargetMonitorNotifyTargetDeregistered.setName(record, aName);
                this.mMessageSender.send(env, record);
            }
            catch (CException cException) {}
        }
    }

    public void triggerTargetAdded(@NotNull CTargetAddress aAddress, @NotNull String aName, @NotNull String aClassName, @NotNull String aSimpleClassName, @NotNull IId aQID) {
        Collection<CTargetAddress> observers = this.privateFilter(aAddress);
        for (CTargetAddress a : observers) {
            try {
                CEnvelope env = CEnvelope.forSingleTarget(a);
                env.setSender(this.mMyAddress);
                CRecord record = CRecordTargetMonitorNotifyTargetRegistered.create();
                CRecordTargetMonitorNotifyTargetRegistered.setAddress(record, aAddress);
                CRecordTargetMonitorNotifyTargetRegistered.setClassName(record, aClassName);
                CRecordTargetMonitorNotifyTargetRegistered.setSimpleClassName(record, aSimpleClassName);
                CRecordTargetMonitorNotifyTargetRegistered.setName(record, aName);
                CRecordTargetMonitorNotifyTargetRegistered.setQueueId(record, aQID);
                this.mMessageSender.send(env, record);
            }
            catch (CException cException) {}
        }
    }
}

