/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.time.CUtilInstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSlotInstant
implements ISlot,
ISingleSlotTypeFactory {
    private final Instant mValue;

    public CSlotInstant() {
        this.mValue = null;
    }

    public CSlotInstant(Instant aValue) {
        this.mValue = aValue;
    }

    public CSlotInstant(@NotNull List<?> aValue) {
        Object object = aValue.get(0);
        this.mValue = this.create(object);
    }

    public CSlotInstant(String aValue) {
        this.mValue = this.create(aValue);
    }

    public CSlotInstant(DataInput aStream) throws IOException {
        this.mValue = CUtilInstant.fromStream(aStream);
    }

    private Instant create(Object aValue) {
        return CUtilInstant.fromObject(aValue);
    }

    @Override
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return new CSlotInstant(this.create(aValue));
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            Instant instant = CUtilInstant.fromIsoString((String)aValue);
            return new CSlotInstant(instant);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotInstant other = (CSlotInstant)aObj;
        return Objects.equals(this.mValue, other.mValue);
    }

    public Instant get() {
        return this.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Instant.class;
    }

    @Override
    public ISlot copy() {
        return this;
    }

    public String getString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.valueToString();
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.INSTANT;
    }

    @Override
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        return this.equals(aValue);
    }

    @Override
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return new CSlotInstant(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilInstant.toStream(aStream, this.mValue);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilInstant.valueToString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null) {
            return CUtilInstant.valueToIsoString(this.mValue);
        }
        return null;
    }
}

