/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilCharArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotCharArray
implements ISlot,
ISingleSlotTypeFactory {
    private final char[] mValue;

    CSlotCharArray() {
        this.mValue = null;
    }

    private CSlotCharArray(char[] aValue) {
        this.mValue = CUtilCharArray.copy(aValue);
    }

    @NotNull
    private static CSlotCharArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof char[]) {
            return new CSlotCharArray((char[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotCharArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotCharArray.fromList((List)aValue);
        }
        return new CSlotCharArray();
    }

    @NotNull
    private static CSlotCharArray fromList(@NotNull List<?> aList) {
        char[] array = CUtilCharArray.fromList(aList);
        return new CSlotCharArray(array);
    }

    @NotNull
    private static CSlotCharArray fromStream(@NotNull DataInput aStream) throws IOException {
        char[] array = CUtilCharArray.fromStream(aStream);
        return new CSlotCharArray(array);
    }

    @NotNull
    private static CSlotCharArray fromString(@NotNull String aValue) {
        char[] value = CUtilCharArray.fromString(aValue);
        return new CSlotCharArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotCharArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        char[] arr = CUtilCharArray.fromJson(aValue);
        return arr == null || arr.length == 0 ? null : new CSlotCharArray(arr);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotCharArray other = (CSlotCharArray)aObj;
        return CUtilCharArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return char[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        char[] value = CUtilCharArray.copy(this.mValue);
        return new CSlotCharArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.CHAR_ARRAY;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof char[]) {
            char[] bb = (char[])aValue;
            return CUtilCharArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotCharArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilCharArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilCharArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilCharArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return CUtilCharArray.toJson(this.mValue);
    }
}

