/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.service.CJobAddStarter;
import de.sillysky.nyssr.impl.service.CJobDeregisterService;
import de.sillysky.nyssr.impl.service.CJobDeregisterServiceInstance;
import de.sillysky.nyssr.impl.service.CJobRegisterService;
import de.sillysky.nyssr.impl.service.CJobStartStarter;
import de.sillysky.nyssr.impl.service.CJobStopStartedStarter;
import de.sillysky.nyssr.impl.service.CService;
import de.sillysky.nyssr.impl.service.CServiceDependency;
import de.sillysky.nyssr.impl.service.CServiceDependencyList;
import de.sillysky.nyssr.impl.service.CServiceRegistryListenerList;
import de.sillysky.nyssr.impl.service.CServiceStarter;
import de.sillysky.nyssr.impl.service.CTestThreadPoolManager;
import de.sillysky.nyssr.impl.service.CThreadPoolManager;
import de.sillysky.nyssr.impl.service.IThreadPoolManager;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.service.IServiceListener;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.job.serial.INotifyJobsFinished;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.time.CUtilLocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CServiceRegistry
implements IServiceRegistry,
INotifyJobsFinished {
    static final ILogger LOG = CLoggerFactory.getLogger(CServiceRegistry.class);
    private static final CServiceRegistry INSTANCE = new CServiceRegistry();
    @NotNull
    private final Map<String, CServiceStarter> mWaitingStarter;
    @NotNull
    private final Map<String, List<CService>> mServices;
    @NotNull
    private final Map<String, CServiceStarter> mStartedStarter;
    @NotNull
    private final CServiceRegistryListenerList mStartServiceListener;
    private final CServiceRegistryListenerList mStopServiceListener;
    private final AtomicBoolean mDirty = new AtomicBoolean(false);
    private static boolean mPrintStatus = false;
    private static String mLastPrintUnsatisfiedStarters = "";
    private IThreadPoolManager mThreadPoolManager;

    private CServiceRegistry() {
        this.mServices = new ConcurrentHashMap<String, List<CService>>();
        this.mStartedStarter = new ConcurrentHashMap<String, CServiceStarter>();
        this.mWaitingStarter = new ConcurrentHashMap<String, CServiceStarter>();
        this.mStartServiceListener = new CServiceRegistryListenerList(this, "StartService");
        this.mStopServiceListener = new CServiceRegistryListenerList(this, "StopService");
        this.mThreadPoolManager = new CThreadPoolManager(8);
    }

    @NotNull
    public static CServiceRegistry getInstance() {
        return INSTANCE;
    }

    @NotNull
    public static CServiceRegistry getTestInstance() {
        if (CServiceRegistry.INSTANCE.mThreadPoolManager instanceof CThreadPoolManager) {
            CServiceRegistry.INSTANCE.mThreadPoolManager = new CTestThreadPoolManager();
        }
        return INSTANCE;
    }

    IThreadPoolManager getThreadPoolManager() {
        return this.mThreadPoolManager;
    }

    @Override
    public void addStarter(@NotNull IServiceStarter aStarter) {
        this.mThreadPoolManager.submitJob(new CJobAddStarter(this, aStarter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkStop() {
        Map<String, CServiceStarter> map = this.mStartedStarter;
        synchronized (map) {
            for (CServiceStarter ss : this.mStartedStarter.values()) {
                CServiceDependencyList deps = ss.getDependencies();
                for (CServiceDependency dep : deps) {
                    if (!this.isNotRegistered(dep)) continue;
                    this.mThreadPoolManager.submitJob(new CJobStopStartedStarter(this, ss));
                }
            }
        }
    }

    @Override
    public void deregisterService(@NotNull Object aInstance) {
        this.mThreadPoolManager.submitJob(new CJobDeregisterServiceInstance(this, aInstance));
    }

    @Override
    public void deregisterStartServiceListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        this.mStartServiceListener.deregisterListener(aClass, aListener);
    }

    @Override
    public void deregisterStopServiceListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        this.mStopServiceListener.deregisterListener(aClass, aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterServiceType(@NotNull Class<?> aClass) {
        String name = aClass.getName();
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            List<CService> removedServices = this.mServices.get(name);
            if (removedServices == null || removedServices.isEmpty()) {
                LOG.error("Service {} not found.", name);
            } else {
                LOG.debug("Service {} will be deregistered...", name);
                for (CService service : removedServices) {
                    this.mThreadPoolManager.submitJob(new CJobDeregisterService(this, service));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CService findService(@NotNull CServiceDependency aDep) {
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            List<CService> list = this.mServices.get(aDep.getService().getName());
            if (list != null) {
                for (CService s : list) {
                    if (!s.match(aDep)) continue;
                    return s;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T getService(@NotNull Class<T> aClass) {
        String name = aClass.getName();
        CServiceDependency dep = new CServiceDependency(aClass);
        CService s = this.findService(dep);
        if (s == null) {
            LOG.debug("Service {} requested, but not found", name);
            return null;
        }
        return (T)s.getInstance();
    }

    @Override
    @NotNull
    public <T> T getServiceOrThrow(@NotNull Class<T> aClass) throws CException {
        String name = aClass.getName();
        CServiceDependency dep = new CServiceDependency(aClass);
        CService s = this.findService(dep);
        if (s == null) {
            LOG.debug("Service {} requested, but not found", name);
            throw new CException(2302);
        }
        return (T)s.getInstance();
    }

    @Override
    @Nullable
    public <T> T getService(@NotNull Class<T> aClass, @NotNull String aProperties) {
        String name = aClass.getName();
        CServiceDependency dep = new CServiceDependency(aClass, aProperties);
        CService s = this.findService(dep);
        if (s == null) {
            LOG.debug("Service {} requested, but not found", name);
            return null;
        }
        return (T)s.getInstance();
    }

    @Override
    @NotNull
    public <T> T getServiceOrThrow(@NotNull Class<T> aClass, @NotNull String aProperties) throws CException {
        String name = aClass.getName();
        CServiceDependency dep = new CServiceDependency(aClass, aProperties);
        CService s = this.findService(dep);
        if (s == null) {
            LOG.debug("Service {} requested, but not found", name);
            throw new CException(2302);
        }
        return (T)s.getInstance();
    }

    boolean isNotRegistered(@NotNull CServiceDependency aDep) {
        return this.findService(aDep) == null;
    }

    void notifyStartServiceListener(@NotNull CService aService) {
        this.mStartServiceListener.notifyListener(aService);
    }

    void notifyStopServiceListener(@NotNull CService aService) {
        this.mStopServiceListener.notifyListener(aService);
    }

    @Override
    public void printStatus() {
        boolean changed = this.mDirty.compareAndSet(true, false);
        if (changed && LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder(3000);
            sb.append(CUtilString.LINE_CRLF);
            sb.append("satisfied starters:\n");
            sb.append(CUtilString.LINE_CRLF);
            for (CServiceStarter s : this.mStartedStarter.values()) {
                sb.append("satisfied:     ");
                sb.append(s.toString());
                sb.append(CUtilString.CRLF);
            }
            sb.append(CUtilString.LINE_CRLF);
            sb.append("registered services:\n");
            sb.append(CUtilString.LINE_CRLF);
            TreeSet<String> t = new TreeSet<String>();
            for (List<CService> l : this.mServices.values()) {
                if (l == null) continue;
                for (CService s : l) {
                    t.add(s.toString());
                }
            }
            for (String key : t) {
                sb.append("Service:     ");
                sb.append(key);
                sb.append(CUtilString.CRLF);
            }
            LOG.trace(sb.toString());
        }
        this.logUnsatisfiedStarters();
    }

    private void logUnsatisfiedStarters() {
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder(4000);
            String s = this.printStatusOfWaitingStarters();
            if (s.isEmpty()) {
                if (mPrintStatus) {
                    sb.append(CUtilString.LINE_CRLF);
                    sb.append("no unsatisfied service starters");
                    IKernelConfiguration kc = CServiceRegistry.getInstance().getService(IKernelConfiguration.class);
                    if (kc != null) {
                        long millis = CUtilLocalDateTime.diffInMillis(kc.getStartTime());
                        sb.append(" after ").append(millis).append(" milliseconds");
                    }
                    sb.append(CUtilString.CRLF);
                    sb.append(CUtilString.LINE_CRLF);
                    LOG.info(sb.toString());
                    mPrintStatus = false;
                }
            } else if (!mLastPrintUnsatisfiedStarters.equals(s)) {
                sb.append(CUtilString.LINE_CRLF);
                sb.append("unsatisfied service starters:\n");
                sb.append(CUtilString.LINE_CRLF);
                sb.append(s);
                LOG.info(sb.toString());
                mPrintStatus = true;
                mLastPrintUnsatisfiedStarters = s;
            }
        }
    }

    @Override
    public void allowStatusPrint() {
        mPrintStatus = true;
    }

    @Override
    public void registerService(@NotNull Class<?> aClass, @Nullable CStringProperties aProperties, @NotNull Object aInstance) {
        this.mThreadPoolManager.submitJob(new CJobRegisterService(this, aClass, aProperties, aInstance));
    }

    @Override
    public void registerService(@NotNull Class<?> aClass, @NotNull Object aInstance) {
        this.registerService(aClass, (CStringProperties)null, aInstance);
    }

    @Override
    public void registerService(@NotNull Class<?> aClass, @NotNull String aProperties, @NotNull Object aInstance) {
        CStringProperties sp = new CStringProperties(aProperties);
        this.registerService(aClass, sp, aInstance);
    }

    @Override
    public void registerStartServiceListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        this.mStartServiceListener.registerListener(aClass, aListener);
    }

    @Override
    public void registerStopServiceListener(@NotNull Class<?> aClass, @NotNull IServiceListener aListener) {
        this.mStopServiceListener.registerListener(aClass, aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStarter(@NotNull IServiceStarter aStarter) {
        String name = aStarter.getClass().getName();
        Map<String, CServiceStarter> map = this.mStartedStarter;
        synchronized (map) {
            CServiceStarter removed = this.mStartedStarter.remove(name);
            if (removed != null) {
                this.mDirty.set(true);
                try {
                    aStarter.stop(this);
                }
                catch (Exception e) {
                    LOG.error(e, "Error: on stopping service {}.", name);
                }
                LOG.debug("Starter {} removed from started Starters", name);
                return;
            }
        }
        this.mWaitingStarter.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted(@NotNull IServiceStarter aStarter) {
        String name = aStarter.getClass().getName();
        Map<String, CServiceStarter> map = this.mStartedStarter;
        synchronized (map) {
            return this.mStartedStarter.containsKey(name);
        }
    }

    @Override
    public void checkServicesForNull(Object ... aArgs) throws CException {
        for (Object o : aArgs) {
            if (o != null) continue;
            throw new CException(2302);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.mThreadPoolManager.reset();
        Map<String, Object> map = this.mServices;
        synchronized (map) {
            this.mServices.clear();
        }
        map = this.mStartedStarter;
        synchronized (map) {
            this.mStartedStarter.clear();
        }
        map = this.mWaitingStarter;
        synchronized (map) {
            this.mWaitingStarter.clear();
        }
        this.mStartServiceListener.reset();
        this.mStopServiceListener.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object getService(@NotNull String aKey) {
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            return this.mServices.get(aKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void privateAddWaitingStarter(@NotNull String aName, @NotNull CServiceStarter aStarter) {
        Map<String, CServiceStarter> map = this.mWaitingStarter;
        synchronized (map) {
            this.mWaitingStarter.put(aName, aStarter);
        }
    }

    @Override
    public void notifyJobsFinished(int aResultCode, @NotNull String aResultText) {
    }

    void setDirty(boolean aDirty) {
        this.mDirty.set(aDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStarterStarted(@NotNull CServiceStarter aServiceStarter) {
        Map<String, CServiceStarter> map = this.mStartedStarter;
        synchronized (map) {
            this.mStartedStarter.put(aServiceStarter.getName(), aServiceStarter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addService(@NotNull String aName, @NotNull CService aService) {
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            List list = this.mServices.computeIfAbsent(aName, k -> new ArrayList());
            list.add(aService);
        }
    }

    void printStatusIf() {
        if (mPrintStatus) {
            this.printStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkWaitingStarters() {
        Map<String, CServiceStarter> map = this.mWaitingStarter;
        synchronized (map) {
            Iterator<CServiceStarter> iterator = this.mWaitingStarter.values().iterator();
            block3: while (iterator.hasNext()) {
                CServiceStarter ss = iterator.next();
                CServiceDependencyList deps = ss.getDependencies();
                for (CServiceDependency dep : deps) {
                    if (!this.isNotRegistered(dep)) continue;
                    continue block3;
                }
                this.mThreadPoolManager.submitJob(new CJobStartStarter(this, ss));
                iterator.remove();
            }
        }
    }

    @NotNull
    String printStatusOfWaitingStarters() {
        if (!this.hasUnsatisfiedStarters()) {
            return "";
        }
        StringBuilder sb1 = new StringBuilder(2000);
        for (CServiceStarter ss : this.mWaitingStarter.values()) {
            boolean print = false;
            StringBuilder sb2 = new StringBuilder(2000);
            sb2.append(ss.getName()).append("\n");
            CServiceDependencyList deps = ss.getDependencies();
            for (CServiceDependency d : deps) {
                String depName = d.getService().getName();
                Object object = this.getService(depName);
                if (object == null) {
                    sb2.append("    not satisfied: ").append(d).append("\n");
                    print = true;
                    continue;
                }
                sb2.append("    satisfied:     ").append(d).append("\n");
            }
            if (!print) continue;
            sb1.append((CharSequence)sb2);
            sb1.append(CUtilString.LINE_CRLF);
        }
        return sb1.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasUnsatisfiedStarters() {
        Map<String, CServiceStarter> map = this.mWaitingStarter;
        synchronized (map) {
            for (CServiceStarter ss : this.mWaitingStarter.values()) {
                CServiceDependencyList deps = ss.getDependencies();
                for (CServiceDependency d : deps) {
                    String depName = d.getService().getName();
                    Object object = this.getService(depName);
                    if (object != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void privateRemoveStartedStarter(@NotNull String aName) {
        Map<String, CServiceStarter> map = this.mStartedStarter;
        synchronized (map) {
            this.mStartedStarter.remove(aName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceInstance(@NotNull Object aInstance) {
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            for (List<CService> list : this.mServices.values()) {
                for (CService s : list) {
                    if (s.getInstance() != aInstance) continue;
                    this.mThreadPoolManager.submitJob(new CJobDeregisterService(this, s));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeService(@NotNull CService aService) {
        String key = aService.getService().getName();
        Map<String, List<CService>> map = this.mServices;
        synchronized (map) {
            List<CService> list = this.mServices.get(key);
            if (list != null) {
                list.remove(aService);
                if (list.isEmpty()) {
                    this.mServices.remove(key);
                }
            }
        }
    }
}

