/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.service;

import de.sillysky.nyssr.impl.service.CServiceDependency;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CService {
    private final Class<?> mService;
    private final Object mInstance;
    private final CStringProperties mProperties;

    CService(@NotNull Class<?> aService, @NotNull Object aInstance, @Nullable CStringProperties aProperties) {
        this.mService = aService;
        this.mInstance = aInstance;
        this.mProperties = aProperties;
    }

    @NotNull
    Object getInstance() {
        return this.mInstance;
    }

    @Nullable
    CStringProperties getProperties() {
        return this.mProperties;
    }

    @NotNull
    Class<?> getService() {
        return this.mService;
    }

    boolean match(@NotNull CServiceDependency aDep) {
        Class<?> s = aDep.getService();
        if (this.mService.equals(s)) {
            CStringProperties p = aDep.getProperties();
            if (this.mProperties == null) {
                return p == null || p.isEmpty();
            }
            return this.mProperties.match(p);
        }
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.mService.getSimpleName());
        if (this.mProperties != null) {
            sb.append(" (");
            sb.append(this.mProperties);
            sb.append(')');
        }
        return sb.toString();
    }
}

