/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import de.sillysky.nyssr.impl.preferences.CBackingStoreException;
import de.sillysky.nyssr.impl.preferences.CPreferences;
import de.sillysky.nyssr.impl.preferences.CPreferencesDescription;
import de.sillysky.nyssr.impl.preferences.IBackingStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;

public abstract class CStreamBackingStore
implements IBackingStore {
    protected abstract void checkAccess() throws CBackingStoreException;

    protected abstract OutputStream getOutputStream(CPreferencesDescription var1) throws IOException;

    private boolean hasChanges(CPreferences aPreferences) {
        if (aPreferences.getChangeSet().hasChanges()) {
            return true;
        }
        for (CPreferences current : aPreferences.getChildren()) {
            if (!this.hasChanges(current)) continue;
            return true;
        }
        return false;
    }

    protected void read(CPreferences aPreferences, InputStream aStream) throws IOException {
        this.readPreferences(aPreferences, aStream);
        ObjectInputStream ois = new ObjectInputStream(aStream);
        int numberOfChildren = ois.readInt();
        for (int i = 0; i < numberOfChildren; ++i) {
            int length = ois.readInt();
            byte[] name = new byte[length];
            ois.readFully(name);
            CPreferences impl = (CPreferences)aPreferences.node(new String(name, StandardCharsets.UTF_8));
            this.read(impl, aStream);
        }
    }

    private void readPreferences(CPreferences aPreferences, InputStream aStream) throws IOException {
        ObjectInputStream ois = new ObjectInputStream(aStream);
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            int keyLength = ois.readInt();
            int valueLength = ois.readInt();
            byte[] key = new byte[keyLength];
            byte[] value = new byte[valueLength];
            ois.readFully(key);
            ois.readFully(value);
            aPreferences.getProperties().put(new String(key, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
        }
    }

    @Override
    public void store(CPreferences aPreferences) throws CBackingStoreException {
        CPreferences p = aPreferences;
        if (!this.hasChanges(p)) {
            return;
        }
        this.checkAccess();
        CPreferences savedData = this.load(p.getBackingStoreManager(), p.getDescription());
        if (savedData != null) {
            CPreferences n = savedData.getOrCreateNode(p.absolutePath());
            n.applyChanges(p);
            p = n;
        }
        CPreferences root = p.getRoot();
        try {
            OutputStream os = this.getOutputStream(root.getDescription());
            this.write(root, os);
            os.close();
        }
        catch (IOException ioe) {
            throw new CBackingStoreException("Unable to store preferences.", ioe);
        }
    }

    @Override
    public void update(CPreferences aPreferences) throws CBackingStoreException {
        CPreferences root = this.load(aPreferences.getBackingStoreManager(), aPreferences.getDescription());
        if (root != null && root.nodeExists(aPreferences.absolutePath())) {
            CPreferences updated = (CPreferences)root.node(aPreferences.absolutePath());
            aPreferences.update(updated);
        }
    }

    private void write(CPreferences aPreferences, OutputStream aStream) throws IOException {
        this.writePreferences(aPreferences, aStream);
        ObjectOutputStream oos = new ObjectOutputStream(aStream);
        Collection<CPreferences> children = aPreferences.getChildren();
        oos.writeInt(children.size());
        oos.flush();
        for (CPreferences child : children) {
            byte[] name = child.name().getBytes(StandardCharsets.UTF_8);
            oos.writeInt(name.length);
            oos.write(name);
            oos.flush();
            this.write(child, aStream);
        }
    }

    private void writePreferences(CPreferences aPreferences, OutputStream aStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(aStream);
        int size = aPreferences.getProperties().size();
        oos.writeInt(size);
        for (Map.Entry<String, String> entry : aPreferences.getProperties().entrySet()) {
            byte[] key = entry.getKey().getBytes(StandardCharsets.UTF_8);
            byte[] value = entry.getValue().getBytes(StandardCharsets.UTF_8);
            oos.writeInt(key.length);
            oos.writeInt(value.length);
            oos.write(key);
            oos.write(value);
        }
        oos.flush();
    }
}

