/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

final class CChangeSet {
    private final Set<String> mChangedProperties = new HashSet<String>();
    private final Set<String> mRemovedProperties = new HashSet<String>();
    private final Set<String> mAddedChildren = new HashSet<String>();
    private final Set<String> mRemovedChildren = new HashSet<String>();
    private boolean mHasChanges = false;

    CChangeSet() {
    }

    void childAdded(String aName) {
        this.mHasChanges = true;
        this.mRemovedChildren.remove(aName);
        this.mAddedChildren.add(aName);
    }

    void childRemoved(String aName) {
        this.mHasChanges = true;
        this.mAddedChildren.remove(aName);
        this.mRemovedChildren.add(aName);
    }

    void clear() {
        this.mHasChanges = false;
        this.mRemovedChildren.clear();
        this.mRemovedProperties.clear();
        this.mAddedChildren.clear();
        this.mChangedProperties.clear();
    }

    Collection<String> getAddedChildren() {
        return Collections.unmodifiableCollection(this.mAddedChildren);
    }

    Collection<String> getChangedProperties() {
        return Collections.unmodifiableCollection(this.mChangedProperties);
    }

    Collection<String> getRemovedChildren() {
        return Collections.unmodifiableCollection(this.mRemovedChildren);
    }

    Collection<String> getRemovedProperties() {
        return Collections.unmodifiableCollection(this.mRemovedProperties);
    }

    boolean hasChanges() {
        return this.mHasChanges;
    }

    void importChanges(CChangeSet other) {
        if (other.mHasChanges) {
            this.mHasChanges = true;
            this.mAddedChildren.addAll(other.mAddedChildren);
            this.mRemovedChildren.addAll(other.mRemovedChildren);
            this.mChangedProperties.addAll(other.mChangedProperties);
            this.mRemovedProperties.addAll(other.mRemovedProperties);
        }
    }

    void propertyChanged(String name) {
        this.mHasChanges = true;
        this.mRemovedProperties.remove(name);
        this.mChangedProperties.add(name);
    }

    void propertyRemoved(String name) {
        this.mHasChanges = true;
        this.mChangedProperties.remove(name);
        this.mRemovedProperties.add(name);
    }
}

