/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config;

import de.sillysky.nyssr.impl.kernel.config.CKernelConfiguration;
import de.sillysky.nyssr.impl.kernel.config.IDependencies;
import de.sillysky.nyssr.properties.string.INodeStringProperties;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class CPackageKernelConfiguration
implements IServiceStarter,
IDependencies {
    private final CStringProperties mProperties;
    private final Map<String, String> mEnvironment;
    private IService mService;
    private INodeStringProperties mNodeStringProperties;

    public CPackageKernelConfiguration(@NotNull CStringProperties aProperties) {
        this.mProperties = aProperties;
        this.mEnvironment = System.getenv();
    }

    public CPackageKernelConfiguration(@NotNull CStringProperties aProperties, @NotNull Map<String, String> aEnvironment) {
        this.mProperties = aProperties;
        this.mEnvironment = aEnvironment;
    }

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INodeStringProperties.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNodeStringProperties = aServiceRegistry.getServiceOrThrow(INodeStringProperties.class);
            this.mService = new CKernelConfiguration(this, this.mProperties, this.mEnvironment);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INodeStringProperties getNodeStringProperties() {
        return this.mNodeStringProperties;
    }
}

