/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.hsm;

import de.sillysky.nyssr.hsm.IHsm;
import de.sillysky.nyssr.hsm.IHsmMessageHandler;
import de.sillysky.nyssr.hsm.IHsmState;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.hsm.CHsmFactory;
import de.sillysky.nyssr.impl.hsm.CHsmMessageHandlerRegistry;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;

final class CHsmState
implements IHsmState {
    private final IHsm mHsm;
    private final String mName;
    private final CHsmMessageHandlerRegistry mMessageHandlerRegistry;
    private final IHsmState mParent;
    private String mFullName;

    CHsmState(CHsmFactory aFactory, IHsm aHsm, IHsmState aParent, String aName) {
        this.mHsm = aHsm;
        this.mParent = aParent;
        this.mName = aName;
        this.createFullName();
        this.mMessageHandlerRegistry = new CHsmMessageHandlerRegistry(aFactory, this.mHsm, this);
    }

    @Override
    public void addMessageHandler(IId aMID, IHsmMessageHandler aHandler) {
        this.mMessageHandlerRegistry.addMessageHandler(aMID, aHandler);
    }

    private void createFullName() {
        this.mFullName = this.mHsm.getHsmName() + '.' + this.mName;
    }

    @Override
    public String getFullName() {
        return this.mFullName;
    }

    @Override
    public IHsm getHSM() {
        return this.mHsm;
    }

    @Override
    public IHsmState getParentState() {
        return this.mParent;
    }

    @Override
    public String getStateName() {
        return this.mName;
    }

    @Override
    public boolean handleMessage(IHsm aHsm, CEnvelope aEnvelope, CRecord aRecord) throws Exception {
        return this.mMessageHandlerRegistry.handleMessage(aHsm, aEnvelope, aRecord);
    }

    @Override
    public void removeMessageHandler(IId aMID) {
        this.mMessageHandlerRegistry.removeMessageHandler(aMID);
    }

    public String toString() {
        return this.mName;
    }
}

