/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.file.attributes;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.attributes.records.CRecordFileAttributes;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.files.CFileAttributes;
import org.jetbrains.annotations.NotNull;

public class CFileAttributeHelper {
    private CFileAttributeHelper() {
    }

    @NotNull
    public static CFileAttributes fromRecord(@NotNull CRecord aRecord) {
        CBitField bitField = CRecordFileAttributes.getFileAttributesBitField(aRecord, null);
        CFileAttributes fa = new CFileAttributes(bitField);
        long timeOfCreation = CRecordFileAttributes.getFileAttributesCreationTime(aRecord, 0L);
        fa.setTimeOfCreation(timeOfCreation);
        long timeOfLastAccess = CRecordFileAttributes.getFileAttributesLastAccessTime(aRecord, 0L);
        fa.setTimeOfLastAccess(timeOfLastAccess);
        long timeOfLastModification = CRecordFileAttributes.getFileAttributesLastModifiedTime(aRecord, 0L);
        fa.setTimeOfLastModification(timeOfLastModification);
        long fileSize = CRecordFileAttributes.getFileAttributesSize(aRecord, 0L);
        fa.setFileSize(fileSize);
        String ownerName = CRecordFileAttributes.getFileAttributesOwnerName(aRecord, null);
        fa.setOwner(ownerName);
        String groupName = CRecordFileAttributes.getFileAttributesGroupName(aRecord, null);
        fa.setGroup(groupName);
        return fa;
    }

    public static void fillRecord(@NotNull CFileAttributes aFileAttributes, @NotNull CRecord aRecord) throws CException {
        CRecordFileAttributes.setFileAttributesBitField(aRecord, aFileAttributes.getBitField());
        CRecordFileAttributes.setFileAttributesCreationTime(aRecord, aFileAttributes.getTimeOfCreation().toMillis());
        CRecordFileAttributes.setFileAttributesLastAccessTime(aRecord, aFileAttributes.getTimeOfLastAccess().toMillis());
        CRecordFileAttributes.setFileAttributesLastModifiedTime(aRecord, aFileAttributes.getTimeOfLastModification().toMillis());
        CRecordFileAttributes.setFileAttributesSize(aRecord, aFileAttributes.getFileSize());
        CRecordFileAttributes.setFileAttributesGroupName(aRecord, aFileAttributes.getGroup());
        CRecordFileAttributes.setFileAttributesOwnerName(aRecord, aFileAttributes.getOwner());
    }

    @NotNull
    public static CRecord createRecord(@NotNull CFileAttributes aFileAttributes) throws CException {
        CRecord record = CRecordFileAttributes.create();
        CFileAttributeHelper.fillRecord(aFileAttributes, record);
        return record;
    }
}

