/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingWindow;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.util.CUtilFloat;
import java.awt.Component;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingFrame
extends CSwingWindow {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingFrame.class);

    CSwingFrame(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("opacity", this::applyOpacity);
        list.addHandler("title", this::applyTitle);
    }

    private boolean applyOpacity(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Number && (component = this.getComponent()) instanceof Frame) {
            Frame frame = (Frame)component;
            float opacity = CUtilFloat.fromObject((Object)aValue);
            LOG.debug("Set Attribute {}: {}", new Object[]{aKey, Float.valueOf(opacity)});
            frame.setOpacity(opacity);
            return true;
        }
        return false;
    }

    private boolean applyTitle(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Frame) {
            Frame frame = (Frame)component;
            if (aValue instanceof String) {
                String value = (String)aValue;
                LOG.debug("Set Attribute {}: {}", new Object[]{aKey, value});
                frame.setTitle(value);
                return true;
            }
        }
        return false;
    }
}

