/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.impl.remoteskin.client.util.CIconHandler;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.enums.EIconUsage;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventHorizontalTextPosition;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.events.CEventMnemonic;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalAlignment;
import de.sillysky.nyssr.remoteskin.model.events.CEventVerticalTextPosition;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.swing.key.CUtilKeyCodes;
import java.awt.Component;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingAbstractButton
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingAbstractButton.class);
    private final CIconHandler mIconHandler = new CIconHandler(this){

        @Override
        public void setIcon(@NotNull Icon aIcon, EIconUsage aUsage) {
            AbstractButton button = CSwingAbstractButton.this.getButtonOrNull();
            if (button != null) {
                switch (aUsage) {
                    case disabled: {
                        button.setDisabledIcon(aIcon);
                        break;
                    }
                    case enabled: {
                        button.setIcon(aIcon);
                        break;
                    }
                    case rollover: {
                        button.setRolloverIcon(aIcon);
                        break;
                    }
                    case rollover_selected: {
                        button.setRolloverSelectedIcon(aIcon);
                        break;
                    }
                    case pressed: {
                        button.setPressedIcon(aIcon);
                        break;
                    }
                    case selected: {
                        button.setSelectedIcon(aIcon);
                        break;
                    }
                    case disabled_selected: {
                        button.setDisabledSelectedIcon(aIcon);
                    }
                }
            }
        }
    };

    protected CSwingAbstractButton(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("borderPainted", this::applyBorderPainted);
        list.addHandler("contentAreaFilled", this::applyContentAreaFilled);
        list.addHandler("doClick", this::applyDoClick);
        list.addHandler("horizontalAlignment", this::applyHorizontalAlignment);
        list.addHandler("horizontalTextPosition", this::applyHorizontalTextPosition);
        list.addHandler("icon", this::applyIcon);
        list.addHandler("icons", this::applyIcons);
        list.addHandler("iconTextGap", this::applyIconTextGap);
        list.addHandler("margin", this::applyMargin);
        list.addHandler("mnemonic", this::applyMnemonic);
        list.addHandler("multiClickThreshold", this::applyMultiClickThreshold);
        list.addHandler("paintFocus", this::applyPaintFocus);
        list.addHandler("rolloverEnabled", this::applyRolloverEnabled);
        list.addHandler("selected", this::applySelected);
        list.addHandler("text", this::applyText);
        list.addHandler("verticalAlignment", this::applyVerticalAlignment);
        list.addHandler("verticalTextPosition", this::applyVerticalTextPosition);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        AbstractButton button = this.getButtonOrNull();
        if (button != null) {
            button.addActionListener(e -> {
                Collection modifiers = CUtilKeyCodes.getActionModifiers((int)e.getModifiers());
                CEventButtonPressedNotification event = new CEventButtonPressedNotification(button.isSelected(), modifiers);
                Object jo = event.toJson();
                this.addNotification("onButtonPressed", jo);
                this.sendNotification();
            });
        }
    }

    private boolean applyMultiClickThreshold(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if ((aValue instanceof Number || aValue instanceof String) && (button = this.getButtonOrNull()) != null) {
            long ms = CUtilLong.fromObject((Object)aValue, (long)10L);
            LOG.debug("Set {} to {}", new Object[]{aKey, ms});
            button.setMultiClickThreshhold(ms);
            return true;
        }
        return false;
    }

    private boolean applySelected(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if (aValue instanceof Boolean && (button = this.getButtonOrNull()) != null) {
            boolean selected = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, selected});
            button.setSelected(selected);
            return true;
        }
        return false;
    }

    private boolean applyRolloverEnabled(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if (aValue instanceof Boolean && (button = this.getButtonOrNull()) != null) {
            boolean enabled = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, enabled});
            button.setRolloverEnabled(enabled);
            return true;
        }
        return false;
    }

    private boolean applyPaintFocus(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if (aValue instanceof Boolean && (button = this.getButtonOrNull()) != null) {
            boolean enabled = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, enabled});
            button.setFocusPainted(enabled);
            return true;
        }
        return false;
    }

    private boolean applyHorizontalTextPosition(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        CEventHorizontalTextPosition event = CEventHorizontalTextPosition.create((Object)aValue);
        if (event != null && (button = this.getButtonOrNull()) != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getHorizontalTextPosition()});
            button.setHorizontalTextPosition(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyHorizontalAlignment(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        CEventHorizontalAlignment event = CEventHorizontalAlignment.create((Object)aValue);
        if (event != null && (button = this.getButtonOrNull()) != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getHorizontalAlignment()});
            button.setHorizontalAlignment(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyVerticalAlignment(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        CEventVerticalAlignment event = CEventVerticalAlignment.create((Object)aValue);
        if (event != null && (button = this.getButtonOrNull()) != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getVerticalAlignment()});
            button.setVerticalAlignment(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyVerticalTextPosition(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        CEventVerticalTextPosition event = CEventVerticalTextPosition.create((Object)aValue);
        if (event != null && (button = this.getButtonOrNull()) != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.getVerticalTextPosition()});
            button.setVerticalTextPosition(event.getSwingConstant());
            return true;
        }
        return false;
    }

    private boolean applyMargin(@NotNull String aKey, @Nullable Object aValue) {
        CEventMargin event = CEventMargin.create((Object)aValue);
        if (event != null) {
            AbstractButton button = this.getButtonOrNull();
            if (button != null) {
                Insets insets = new Insets(event.getTop(), event.getLeft(), event.getBottom(), event.getRight());
                button.setMargin(insets);
            }
            return true;
        }
        return false;
    }

    private boolean applyIconTextGap(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int gap = CUtilInteger.fromObject((Object)aValue, (int)0);
            AbstractButton button = this.getButtonOrNull();
            if (button != null) {
                button.setIconTextGap(gap);
            }
            return true;
        }
        return false;
    }

    private boolean applyDoClick(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            int pressTime = CUtilInteger.fromObject((Object)aValue, (int)0);
            AbstractButton button = this.getButtonOrNull();
            if (button != null) {
                button.doClick(pressTime);
            }
            return true;
        }
        return false;
    }

    private boolean applyBorderPainted(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if (aValue instanceof Boolean && (button = this.getButtonOrNull()) != null) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set BorderPainted to {}", new Object[]{b});
            button.setBorderPainted(b);
            return true;
        }
        return false;
    }

    private boolean applyContentAreaFilled(@NotNull String aKey, @Nullable Object aValue) {
        AbstractButton button;
        if (aValue instanceof Boolean && (button = this.getButtonOrNull()) != null) {
            boolean b = (Boolean)aValue;
            LOG.debug("Set ContentAreaFilled to {}", new Object[]{b});
            button.setContentAreaFilled(b);
            return true;
        }
        return false;
    }

    private boolean applyIcon(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvent(aValue);
    }

    private boolean applyIcons(@NotNull String aKey, @Nullable Object aValue) {
        return this.mIconHandler.handleEvents(aValue);
    }

    private boolean applyMnemonic(@NotNull String aKey, @Nullable Object aValue) {
        CEventMnemonic event;
        AbstractButton button = this.getButtonOrNull();
        if (button != null && (event = CEventMnemonic.create((Object)aValue)) != null) {
            int swingConstant = event.getSwingConstant();
            if (swingConstant >= 0) {
                button.setMnemonic(swingConstant);
            } else {
                char character = event.getCharacter();
                if (character != '\u0000') {
                    button.setMnemonic(character);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyText(@NotNull String aKey, @Nullable Object aValue) {
        CEventText event;
        AbstractButton button = this.getButtonOrNull();
        if (button != null && (event = CEventText.create((Object)aValue)) != null) {
            String text = event.getText();
            LOG.debug("Set Text to {}", new Object[]{text});
            button.setText(text);
            return true;
        }
        return false;
    }

    @Nullable
    private AbstractButton getButtonOrNull() {
        Component component = this.getComponent();
        if (component instanceof AbstractButton) {
            return (AbstractButton)component;
        }
        return null;
    }

    @Override
    public void fileArrived(@NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        super.fileArrived(aRelativePath, aToken, aImage);
        this.mIconHandler.fileArrived(aToken, aImage);
    }
}

