/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.util;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.IDialog;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventColorChooserDialogNotification;
import de.sillysky.nyssr.remoteskin.model.events.dialogs.CEventShowColorChooserDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CColorChooserDialog
implements IDialog {
    private final CWidget mWidget;
    private JDialog mDialog;
    private JColorChooser mColorChooser;

    public CColorChooserDialog(@NotNull CWidget aWidget) {
        this.mWidget = aWidget;
    }

    @Override
    public boolean show(@NotNull String aKey, @Nullable Object aValue) {
        CEventShowColorChooserDialog event = CEventShowColorChooserDialog.create((Object)aValue);
        if (event != null) {
            this.mColorChooser = new JColorChooser(event.getColor().createColor());
            this.mColorChooser.getSelectionModel().addChangeListener(this::onColorChange);
            this.mDialog = JColorChooser.createDialog(this.mWidget.getComponent(), event.getTitle(), event.isModal(), this.mColorChooser, this::okListener, this::cancelListener);
            this.mDialog.setVisible(true);
            return true;
        }
        return false;
    }

    private void cancelListener(ActionEvent aActionEvent) {
        this.mDialog.dispose();
        CEventColorChooserDialogNotification event = new CEventColorChooserDialogNotification(null, false, true);
        this.mWidget.addNotification("onColorChooser", event.toJson());
        this.mWidget.sendNotification();
    }

    private void okListener(ActionEvent aActionEvent) {
        Color color = this.mColorChooser.getColor();
        this.mDialog.dispose();
        CEventColor colorEvent = new CEventColor(color);
        CEventColorChooserDialogNotification event = new CEventColorChooserDialogNotification(colorEvent, true, false);
        this.mWidget.addNotification("onColorChooser", event.toJson());
        this.mWidget.sendNotification();
    }

    private void onColorChange(ChangeEvent aChangeEvent) {
        Color color = this.mColorChooser.getColor();
        CEventColor colorEvent = new CEventColor(color);
        CEventColorChooserDialogNotification event = new CEventColorChooserDialogNotification(colorEvent, false, false);
        this.mWidget.addNotification("onColorChooser", event.toJson());
        this.mWidget.sendNotification();
    }
}

