/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.password.change;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.dialog.password.change.C800Handler;
import de.sillysky.nyssr.impl.dialog.password.change.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.remoteskin.server.dialoghelper.IDialogFlavor;
import de.sillysky.nyssr.session.CConstantsSession;
import de.sillysky.nyssr.session.api.records.CRecordUserDbChangePassword;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.timer.CTimer;
import org.jetbrains.annotations.NotNull;

class CMainTarget
extends CTarget {
    private static final String[] JSON = new String[]{"/json/800_PasswordChange.json", "/json/801_PasswordChangeWithUserId.json"};
    private static final IId TIMER = CIdFactory.fromObject((Object)"Timer");
    public static final long DELAY = 3000L;
    private final IDependencies mDependencies;
    private final CDialogDto mDialogDto;
    private final String mInstance;
    private final String mUserId;
    private C800Handler m800Handler;
    private CTargetAddress mUserDbAddress;
    private CTimer mTimer;

    CMainTarget(@NotNull IDependencies aDependencies, @NotNull CDialogDto aDialogDto, @NotNull String aUserId) {
        this.mDependencies = aDependencies;
        this.mDialogDto = aDialogDto;
        this.mUserId = aUserId;
        this.mInstance = aDialogDto.getParentWidgetId().getWidgetSetId().getInstance();
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordUserDbChangePassword.ID, this::asyncChangePassword);
        this.addMessageHandler(TIMER, this::asyncTimer);
        IDialogFlavor dialogFlavor = this.mDependencies.getDialogFlavorFactory().createHelper(this.mDialogDto);
        dialogFlavor.initialize((CTarget)this, JSON);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.m800Handler = new C800Handler(this, this.mDialogDto.getServerContext(), this.mInstance, this.mUserId);
        this.m800Handler.mount(this.mDialogDto.getParentWidgetId());
        this.mTimer = new CTimer(this.mDependencies.getTimerManager(), TIMER, this.getAddress(), 3000L, false, null);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncChangePassword(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                this.mUserDbAddress = aEnvelope.getSender();
                this.mTimer.startIf();
                this.m800Handler.setMessage("Password successfully changed.");
            } else if (resultCode == 2001) {
                this.m800Handler.setMessage("Error: Session Manager not found.");
            } else {
                this.mUserDbAddress = aEnvelope.getSender();
                this.m800Handler.setMessage("Error: " + aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private boolean asyncTimer(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mTimer.notifyTriggerOccurred();
        this.m800Handler.unmount();
        this.deregisterTarget();
        aEnvelope.setResultSuccess();
        return true;
    }

    void notifyWs800Loaded() {
    }

    CDialogDto getDialogDto() {
        return this.mDialogDto;
    }

    public void sendChangePassword(@NotNull String aUserId, @NotNull String aEncodedCurrentPassword, @NotNull String aEncodedNewPassword) throws CException {
        CRecord record = CRecordUserDbChangePassword.create();
        CRecordUserDbChangePassword.setUserId((CRecord)record, (String)aUserId);
        CRecordUserDbChangePassword.setCurrentPassword((CRecord)record, (String)aEncodedCurrentPassword);
        CRecordUserDbChangePassword.setNewPassword((CRecord)record, (String)aEncodedNewPassword);
        this.sendMessageToSessionManager(record);
    }

    private void sendMessageToSessionManager(@NotNull CRecord aRecord) throws CException {
        CEnvelope env = this.mUserDbAddress != null ? CEnvelope.forSingleTarget((CTargetAddress)this.mUserDbAddress) : CEnvelope.forMicroService((IId)CConstantsSession.MICRO_SERVICE_ID);
        this.sendRequest(env, aRecord);
    }
}

