/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.nodechooserdlg.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkChooseNode
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"ad3de13b-e2cc-4890-877c-b40b75d4111c");
    public static final String NAME = "NetworkChooseNode";
    public static final String DESCRIPTION = "Choose a node. This service will be observed if the Connection PlugIn is installed. It presents a Dialog box where the user can choose a connected node.";
    public static final String SLOT_MODAL = "3";
    public static final String SLOT_NODE = "10";
    public static final String SLOT_PARENT_WINDOW = "1";
    public static final String SLOT_TITLE = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getModal(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MODAL);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static CNodeAddress getNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static Object getParentWindow(@NotNull CRecord aRecord, Object aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PARENT_WINDOW);
        if (slot == null) {
            return aDefault;
        }
        return slot.getValue();
    }

    public static String getTitle(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TITLE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setModal(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_MODAL, slot);
    }

    public static void setNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_NODE, slot);
    }

    public static void setParentWindow(@NotNull CRecord aRecord, Object aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.OBJECT, (Object)aValue);
        aRecord.addSlot(SLOT_PARENT_WINDOW, slot);
    }

    public static void setTitle(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_TITLE, slot);
    }
}

